/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.time.Clock;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.ClientGoneException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.web.Hub;
import org.openqa.grid.web.servlet.handler.LegacySeleniumRequest;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.grid.web.servlet.handler.SeleniumBasedResponse;
import org.openqa.grid.web.servlet.handler.WebDriverRequest;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.jmx.ManagedAttribute;
import org.openqa.selenium.remote.server.jmx.ManagedService;

@ManagedService
public class TestSession {
    private static final Logger log = Logger.getLogger(TestSession.class.getName());
    static final int MAX_IDLE_TIME_BEFORE_CONSIDERED_ORPHANED = 5000;
    private final String internalKey;
    private final TestSlot slot;
    private volatile ExternalSessionKey externalKey = null;
    private volatile long sessionCreatedAt;
    private volatile long lastActivity;
    private final Map<String, Object> requestedCapabilities;
    private Map<String, Object> objects = Collections.synchronizedMap(new HashMap());
    private volatile boolean ignoreTimeout = false;
    private final Clock clock;
    private volatile boolean forwardingRequest;
    private final int MAX_NETWORK_LATENCY = 1000;

    public String getInternalKey() {
        return this.internalKey;
    }

    public TestSession(TestSlot slot, Map<String, Object> requestedCapabilities, Clock clock) {
        this.internalKey = UUID.randomUUID().toString();
        this.slot = slot;
        this.requestedCapabilities = requestedCapabilities;
        this.clock = clock;
        this.lastActivity = this.clock.millis();
    }

    @ManagedAttribute
    public Map<String, Object> getRequestedCapabilities() {
        return this.requestedCapabilities;
    }

    public ExternalSessionKey getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(ExternalSessionKey externalKey) {
        this.externalKey = externalKey;
        this.sessionCreatedAt = this.lastActivity;
    }

    @ManagedAttribute
    public long getInactivityTime() {
        if (this.ignoreTimeout) {
            return 0L;
        }
        return this.clock.millis() - this.lastActivity;
    }

    @ManagedAttribute
    public boolean isOrphaned() {
        long elapsedSinceCreation = this.clock.millis() - this.sessionCreatedAt;
        return this.slot.getProtocol().equals((Object)SeleniumProtocol.Selenium) && elapsedSinceCreation > 5000L && this.sessionCreatedAt == this.lastActivity;
    }

    public TestSlot getSlot() {
        return this.slot;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.internalKey == null ? 0 : this.internalKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSession other = (TestSession)obj;
        return this.internalKey.equals(other.internalKey);
    }

    public String toString() {
        return this.externalKey != null ? "ext. key " + this.externalKey : this.internalKey + " (int. key, remote not contacted yet.)";
    }

    private HttpClient getClient(URL url) {
        Integer browserTimeout = this.slot.getProxy().getConfig().browserTimeout;
        return this.slot.getProxy().getHttpClient(url, browserTimeout, browserTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String forward(SeleniumBasedRequest request, HttpServletResponse response, boolean newSessionRequest) throws IOException {
        String res = null;
        String currentThreadName = Thread.currentThread().getName();
        this.setThreadDisplayName();
        this.forwardingRequest = true;
        try {
            if (this.slot.getProxy() instanceof CommandListener) {
                ((CommandListener)((Object)this.slot.getProxy())).beforeCommand(this, (HttpServletRequest)request, response);
            }
            this.lastActivity = this.clock.millis();
            HttpRequest proxyRequest = this.prepareProxyRequest((HttpServletRequest)request);
            HttpResponse proxyResponse = this.sendRequestToNode(proxyRequest);
            this.lastActivity = this.clock.millis();
            int statusCode = proxyResponse.getStatus();
            response.setStatus(statusCode);
            this.processResponseHeaders((HttpServletRequest)request, response, this.slot.getRemoteURL(), proxyResponse);
            byte[] consumedNewWebDriverSessionBody = null;
            if (statusCode != 500 && statusCode != 404 && statusCode != 400 && statusCode != 401) {
                consumedNewWebDriverSessionBody = this.updateHubIfNewWebDriverSession(request, proxyResponse);
            }
            if (newSessionRequest && (statusCode == 500 || statusCode == 400 || statusCode == 401)) {
                this.removeIncompleteNewSessionRequest();
            }
            consumedNewWebDriverSessionBody = this.closeSessionIfNecessary(consumedNewWebDriverSessionBody, request, proxyResponse);
            byte[] contentBeingForwarded = null;
            if (proxyResponse.getContentString() != null) {
                contentBeingForwarded = proxyResponse.getContent();
                if (consumedNewWebDriverSessionBody == null) {
                    if (request.getRequestType() == RequestType.START_SESSION && request instanceof LegacySeleniumRequest) {
                        res = proxyResponse.getContentString();
                        this.updateHubNewSeleniumSession(res);
                        contentBeingForwarded = res.getBytes("UTF-8");
                    }
                } else {
                    contentBeingForwarded = consumedNewWebDriverSessionBody;
                }
            }
            if (this.slot.getProxy() instanceof CommandListener) {
                SeleniumBasedResponse wrappedResponse = new SeleniumBasedResponse(response);
                wrappedResponse.setForwardedContent(contentBeingForwarded);
                ((CommandListener)((Object)this.slot.getProxy())).afterCommand(this, (HttpServletRequest)request, (HttpServletResponse)wrappedResponse);
                contentBeingForwarded = wrappedResponse.getForwardedContentAsByteArray();
            }
            if (contentBeingForwarded != null) {
                this.writeRawBody(response, contentBeingForwarded);
            }
            response.flushBuffer();
            response.flushBuffer();
            String string = res;
            return string;
        }
        finally {
            this.forwardingRequest = false;
            Thread.currentThread().setName(currentThreadName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] closeSessionIfNecessary(byte[] consumed, SeleniumBasedRequest request, HttpResponse proxyResponse) throws IOException {
        if (request instanceof LegacySeleniumRequest) {
            if (proxyResponse.getStatus() != 404) return consumed;
            this.removeSessionBrowserTimeout();
            return consumed;
        }
        if (proxyResponse.getContentString() == null) {
            return consumed;
        }
        if (consumed == null) {
            consumed = proxyResponse.getContent();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(consumed);
             InputStreamReader reader = new InputStreamReader((InputStream)in, proxyResponse.getContentEncoding());){
            Object body = new Json().newInput((Reader)reader).read(Object.class);
            if (!(body instanceof Map)) return consumed;
            Map json = (Map)body;
            Object raw = json.get("status");
            if (raw instanceof Number && ((Number)raw).intValue() == 6) {
                this.removeSessionBrowserTimeout();
                byte[] byArray = consumed;
                return byArray;
            }
            raw = json.get("value");
            if (!(raw instanceof Map)) return consumed;
            Map w3c = (Map)raw;
            if (!"invalid session id".equals(w3c.get("error"))) return consumed;
            this.removeSessionBrowserTimeout();
            byte[] byArray = consumed;
            return byArray;
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
        return consumed;
    }

    private void setThreadDisplayName() {
        DateFormat dfmt = DateFormat.getTimeInstance();
        String name = "Forwarding " + this + " to " + this.slot.getRemoteURL() + " at " + dfmt.format(Calendar.getInstance().getTime());
        Thread.currentThread().setName(name);
    }

    private void removeIncompleteNewSessionRequest() {
        RemoteProxy proxy = this.slot.getProxy();
        proxy.getRegistry().terminate(this, SessionTerminationReason.CREATIONFAILED);
    }

    private void removeSessionBrowserTimeout() {
        RemoteProxy proxy = this.slot.getProxy();
        proxy.getRegistry().terminate(this, SessionTerminationReason.BROWSER_TIMEOUT);
    }

    private void updateHubNewSeleniumSession(String content) {
        ExternalSessionKey key = ExternalSessionKey.fromResponseBody(content);
        this.setExternalKey(key);
    }

    private byte[] updateHubIfNewWebDriverSession(SeleniumBasedRequest request, HttpResponse proxyResponse) {
        if (request.getRequestType() != RequestType.START_SESSION || !(request instanceof WebDriverRequest)) {
            return null;
        }
        String h = proxyResponse.getHeader("Location");
        if (h != null) {
            ExternalSessionKey key = ExternalSessionKey.fromWebDriverRequest(h);
            this.setExternalKey(key);
            return null;
        }
        if (TestSession.isSuccessJsonResponse(proxyResponse) && proxyResponse.getContent() != null) {
            Charset encoding = proxyResponse.getContentEncoding();
            byte[] consumedData = proxyResponse.getContent();
            String contentString = new String(consumedData, encoding);
            ExternalSessionKey key = ExternalSessionKey.fromJsonResponseBody(contentString);
            if (key == null) {
                throw new GridException("webdriver new session JSON response body did not contain a session ID");
            }
            this.setExternalKey(key);
            return consumedData;
        }
        throw new GridException("new session request for webdriver should contain a location header or an 'application/json;charset=UTF-8' response body with the session ID.");
    }

    private static boolean isSuccessJsonResponse(HttpResponse response) {
        if (response.getStatus() == 200) {
            for (String header : response.getHeaders("Content-Type")) {
                MediaType type;
                try {
                    type = MediaType.parse((String)header);
                }
                catch (IllegalArgumentException ignored) {
                    continue;
                }
                if (!MediaType.JSON_UTF_8.is(type) && !MediaType.JAVASCRIPT_UTF_8.is(type)) continue;
                return true;
            }
        }
        return false;
    }

    private HttpResponse sendRequestToNode(HttpRequest proxyRequest) throws IOException {
        HttpClient client = this.getClient(this.slot.getRemoteURL());
        return client.execute(proxyRequest);
    }

    private HttpRequest prepareProxyRequest(HttpServletRequest request) throws IOException {
        HttpRequest proxyRequest;
        URL remoteURL = this.slot.getRemoteURL();
        String pathSpec = request.getServletPath() + request.getContextPath();
        String path = request.getRequestURI();
        if (!path.startsWith(pathSpec)) {
            throw new IllegalStateException("Expected path " + path + " to start with pathSpec " + pathSpec);
        }
        String end = path.substring(pathSpec.length());
        String ok = remoteURL + end;
        if (request.getQueryString() != null) {
            ok = ok + "?" + request.getQueryString();
        }
        String uri = new URL(remoteURL, ok).toExternalForm();
        ServletInputStream body = null;
        if (request.getContentLength() > 0 || request.getHeader("Transfer-Encoding") != null) {
            body = request.getInputStream();
        }
        if (body != null) {
            proxyRequest = new HttpRequest(HttpMethod.valueOf((String)request.getMethod()), uri);
            proxyRequest.setContent(ByteStreams.toByteArray((InputStream)body));
        } else {
            proxyRequest = new HttpRequest(HttpMethod.valueOf((String)request.getMethod()), uri);
        }
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            if ("Content-Length".equalsIgnoreCase(headerName)) continue;
            proxyRequest.setHeader(headerName, request.getHeader(headerName));
        }
        return proxyRequest;
    }

    private void writeRawBody(HttpServletResponse response, byte[] rawBody) throws IOException {
        try (ServletOutputStream out = response.getOutputStream();){
            if (!response.containsHeader("Content-Length")) {
                response.setIntHeader("Content-Length", rawBody.length);
            }
            out.write(rawBody);
        }
        catch (IOException e) {
            throw new ClientGoneException(e);
        }
    }

    private void processResponseHeaders(HttpServletRequest request, HttpServletResponse response, URL remoteURL, HttpResponse proxyResponse) throws MalformedURLException {
        String pathSpec = request.getServletPath() + request.getContextPath();
        for (String name : proxyResponse.getHeaderNames()) {
            for (String value : proxyResponse.getHeaders(name)) {
                if (name.equalsIgnoreCase("Transfer-Encoding") && value.equalsIgnoreCase("chunked")) continue;
                if (name.equalsIgnoreCase("Location")) {
                    URL returnedLocation = new URL(remoteURL, value);
                    String driverPath = remoteURL.getPath();
                    String wrongPath = returnedLocation.getPath();
                    String correctPath = wrongPath.replace(driverPath, "");
                    Hub hub = this.slot.getProxy().getRegistry().getHub();
                    response.setHeader(name, hub.getUrl(pathSpec + correctPath).toString());
                    continue;
                }
                response.setHeader(name, value);
            }
        }
    }

    public Object get(String key) {
        return this.objects.get(key);
    }

    public void put(String key, Object value) {
        this.objects.put(key, value);
    }

    public boolean sendDeleteSessionRequest() {
        boolean ok;
        HttpRequest request;
        URL remoteURL = this.slot.getRemoteURL();
        switch (this.slot.getProtocol()) {
            case Selenium: {
                request = new HttpRequest(HttpMethod.POST, remoteURL.toExternalForm() + "/?cmd=testComplete&sessionId=" + this.getExternalKey().getKey());
                break;
            }
            case WebDriver: {
                String uri = remoteURL.toString() + "/session/" + this.externalKey;
                request = new HttpRequest(HttpMethod.DELETE, uri);
                break;
            }
            default: {
                throw new GridException("Error, protocol not implemented.");
            }
        }
        try {
            HttpClient client = this.getClient(remoteURL);
            HttpResponse response = client.execute(request);
            int code = response.getStatus();
            ok = code >= 200 && code <= 299;
        }
        catch (Throwable e) {
            ok = false;
            log.severe("Unable to send DELETE request for the current session " + e.getMessage());
        }
        return ok;
    }

    public void setIgnoreTimeout(boolean ignore) {
        if (!ignore) {
            this.lastActivity = this.clock.millis();
        }
        this.ignoreTimeout = ignore;
    }

    public boolean isForwardingRequest() {
        return this.forwardingRequest;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        return new ObjectName(String.format("org.seleniumhq.grid:type=TestSession,node=\"%s\",browser=\"%s\",id=%s", this.getSlot().getRemoteURL(), this.getRequestedCapabilities().get("browserName"), this.getInternalKey()));
    }
}

