/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.selenium.Platform;

public class LegacySeleniumRequest
extends SeleniumBasedRequest {
    public LegacySeleniumRequest(HttpServletRequest httpServletRequest, GridRegistry registry) {
        super(httpServletRequest, registry);
    }

    @Override
    public RequestType extractRequestType() {
        if (this.getBody().contains("cmd=getNewBrowserSession")) {
            return RequestType.START_SESSION;
        }
        if (this.getBody().contains("cmd=testComplete")) {
            return RequestType.STOP_SESSION;
        }
        return RequestType.REGULAR;
    }

    @Override
    public ExternalSessionKey extractSession() {
        String[] pieces;
        if (this.getRequestType() == RequestType.START_SESSION) {
            throw new IllegalAccessError("Cannot call that method of a new session request.");
        }
        String command = this.getBody();
        for (String piece : pieces = command.split("&")) {
            ExternalSessionKey externalSessionKey = ExternalSessionKey.fromSe1Request(piece);
            if (externalSessionKey == null) continue;
            return externalSessionKey;
        }
        return null;
    }

    @Override
    public Map<String, Object> extractDesiredCapability() {
        String[] pieces;
        if (this.getRequestType() != RequestType.START_SESSION) {
            throw new Error("the desired capability is only present in the new session requests.");
        }
        for (String piece : pieces = this.getBody().split("&")) {
            try {
                piece = URLDecoder.decode(piece, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (!piece.startsWith("1=")) continue;
            String envt = piece.replace("1=", "");
            HashMap<String, Object> cap = new HashMap<String, Object>();
            cap.putAll(this.parseGrid2Environment(envt));
            return cap;
        }
        throw new RuntimeException("Error");
    }

    private Map<String, Object> parseGrid2Environment(String environment) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String[] details = environment.split(" ");
        if (details.length == 1) {
            ret.put("browserName", details[0]);
        } else {
            ret.put("browserName", details[0]);
            if (details.length == 3) {
                ret.put("platform", Platform.extractFromSysProperty((String)details[2]));
            }
        }
        return ret;
    }

    @Override
    public String getBody() {
        String postBody = super.getBody();
        return postBody != null && !postBody.equals("") ? postBody : this.getQueryString();
    }
}

