/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.util.List;
import java.util.Map;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.cli.BrowserDesiredCapabilityConverter;
import org.openqa.grid.internal.cli.CommonGridCliOptions;
import org.openqa.grid.internal.cli.FileExistsValueValidator;
import org.openqa.grid.internal.cli.NoOpParameterSplitter;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.json.Json;

public class GridNodeCliOptions
extends CommonGridCliOptions {
    @Parameter(names={"-nodeConfig"}, description="<String> filename : JSON configuration file for the node. Overrides default values", validateValueWith={FileExistsValueValidator.class})
    private String configFile;
    @Parameter(names={"-remoteHost"}, description="<String> URL: Address to report to the hub. Used to override default (http://<host>:<port>).")
    private String remoteHost;
    @Parameter(names={"-hubHost"}, description="<String> IP or hostname : the host address of the hub we're attempting to register with. If -hub is specified the -hubHost is determined from it.")
    private String hubHost;
    @Parameter(names={"-hubPort"}, description="<Integer> : the port of the hub we're attempting to register with. If -hub is specified the -hubPort is determined from it.")
    private Integer hubPort;
    @Parameter(names={"-id"}, description="<String> : optional unique identifier for the node. Defaults to the url of the remoteHost, when not specified.")
    private String id;
    @Parameter(names={"-capabilities", "-browser"}, description="<String> : comma separated Capability values. Example: -capabilities browserName=firefox,platform=linux -capabilities browserName=chrome,platform=linux", listConverter=BrowserDesiredCapabilityConverter.class, converter=BrowserDesiredCapabilityConverter.class, splitter=NoOpParameterSplitter.class)
    private List<MutableCapabilities> capabilities;
    @Parameter(names={"-downPollingLimit"}, description="<Integer> : node is marked as \"down\" if the node hasn't responded after the number of checks specified in [downPollingLimit].")
    private Integer downPollingLimit;
    @Parameter(names={"-hub"}, description="<String> : the url that will be used to post the registration request. This option takes precedence over -hubHost and -hubPort options.")
    private String hub;
    @Parameter(names={"-nodePolling"}, description="<Integer> in ms : specifies how often the hub will poll to see if the node is still responding.")
    private Integer nodePolling;
    @Parameter(names={"-nodeStatusCheckTimeout"}, description="<Integer> in ms : connection/socket timeout, used for node \"nodePolling\" check.")
    private Integer nodeStatusCheckTimeout;
    @Parameter(names={"-proxy"}, description="<String> : the class used to represent the node proxy. Default is [org.openqa.grid.selenium.proxy.DefaultRemoteProxy].")
    private String proxy;
    @Parameter(names={"-register"}, description="if specified, node will attempt to re-register itself automatically with its known grid hub if the hub becomes unavailable.", arity=1)
    private Boolean register;
    @Parameter(names={"-registerCycle"}, description="<Integer> in ms : specifies how often the node will try to register itself again. Allows administrator to restart the hub without restarting (or risk orphaning) registered nodes. Must be specified with the \"-register\" option.")
    private Integer registerCycle;
    @Parameter(names={"-unregisterIfStillDownAfter"}, description="<Integer> in ms : if the node remains down for more than [unregisterIfStillDownAfter] ms, it will stop attempting to re-register from the hub.")
    private Integer unregisterIfStillDownAfter;
    @Parameter(names={"-enablePlatformVerification"}, arity=1, description="<Boolean>: Whether or not to drop capabilities that does not belong to the current platform family. Defaults to true.")
    private Boolean enablePlatformVerification;

    public GridNodeCliOptions parse(String[] args) {
        JCommander.newBuilder().addObject((Object)this).build().parse(args);
        if (this.configFile != null) {
            JCommander.newBuilder().addObject((Object)this).defaultProvider(this.defaults(this.fromConfigFile(this.configFile))).build().parse(args);
        }
        return this;
    }

    private IDefaultProvider defaults(String json) {
        Map map = (Map)new Json().toType(json, Map.class);
        map.remove("custom");
        map.remove("capabilities");
        map.remove("servlets");
        map.remove("withoutServlets");
        return optionName -> {
            String option = optionName.replaceAll("-", "");
            return map.containsKey(option) ? map.get(option).toString() : null;
        };
    }

    @Override
    public GridNodeConfiguration toConfiguration() {
        GridNodeConfiguration configuration = GridNodeConfiguration.loadFromJSON(this.configFile == null ? "org/openqa/grid/common/defaults/DefaultNodeWebDriver.json" : this.configFile);
        this.fillCommonConfiguration(configuration);
        this.fillCommonGridConfiguration(configuration);
        if (this.hub != null) {
            configuration.hub = this.hub;
            if (this.hubHost != null) {
                throw new GridConfigurationException("You can't specify both -hubHost and -hub options at the same time");
            }
            if (this.hubPort != null) {
                throw new GridConfigurationException("You can't specify both -hubPort and -hub options at the same time");
            }
            configuration.hubHost = null;
            configuration.hubPort = null;
        } else if (this.hubHost != null && this.hubPort != null) {
            configuration.hub = null;
            configuration.hubHost = this.hubHost;
            configuration.hubPort = this.hubPort;
        }
        if (this.configFile != null) {
            configuration.nodeConfigFile = this.configFile;
        }
        if (this.remoteHost != null) {
            configuration.remoteHost = this.remoteHost;
        }
        if (this.id != null) {
            configuration.id = this.id;
        }
        if (this.capabilities != null) {
            configuration.capabilities = this.capabilities;
        }
        if (this.downPollingLimit != null) {
            configuration.downPollingLimit = this.downPollingLimit;
        }
        if (this.nodePolling != null) {
            configuration.nodePolling = this.nodePolling;
        }
        if (this.nodeStatusCheckTimeout != null) {
            configuration.nodeStatusCheckTimeout = this.nodeStatusCheckTimeout;
        }
        if (this.proxy != null) {
            configuration.proxy = this.proxy;
        }
        if (this.register != null) {
            configuration.register = this.register;
        }
        if (this.registerCycle != null) {
            configuration.registerCycle = this.registerCycle;
        }
        if (this.unregisterIfStillDownAfter != null) {
            configuration.unregisterIfStillDownAfter = this.unregisterIfStillDownAfter;
        }
        if (this.enablePlatformVerification != null) {
            configuration.enablePlatformVerification = this.enablePlatformVerification;
        }
        return configuration;
    }
}

