/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.proxy;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.selenium.proxy.WebRemoteProxy;

public class SeleniumRemoteProxy
extends WebRemoteProxy
implements CommandListener {
    private static final Logger log = Logger.getLogger(SeleniumRemoteProxy.class.getName());
    private CapabilityMatcher matchFFprofileToo;

    public SeleniumRemoteProxy(RegistrationRequest request, Registry registry) {
        super(request, registry);
    }

    public void beforeRelease(TestSession session) {
        log.info("Releasing session: " + session);
        boolean ok = true;
        try {
            if (session.getExternalKey() == null) {
                log.warning("No external key yet. Did the app start properly?");
            } else {
                ok = session.sendSelenium1TestComplete(session);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ok = false;
        }
        if (!ok) {
            log.warning("Error releasing the resources on timeout for session " + session);
        }
    }

    public CapabilityMatcher getCapabilityHelper() {
        if (this.matchFFprofileToo == null) {
            this.matchFFprofileToo = new DefaultCapabilityMatcher(){

                @Override
                public boolean matches(Map<String, Object> currentCapability, Map<String, Object> requestedCapability) {
                    String path = (String)requestedCapability.get("profilePath");
                    if (path != null && !path.equals(currentCapability.get("profilePath"))) {
                        return false;
                    }
                    if (path == null && currentCapability.get("profilePath") != null) {
                        return false;
                    }
                    return super.matches(currentCapability, requestedCapability);
                }
            };
        }
        return this.matchFFprofileToo;
    }
}

