/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.JsonHttpCommandCodec;
import org.openqa.selenium.remote.http.JsonHttpResponseCodec;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.handler.AcceptAlert;
import org.openqa.selenium.remote.server.handler.AddConfig;
import org.openqa.selenium.remote.server.handler.AddCookie;
import org.openqa.selenium.remote.server.handler.CaptureScreenshot;
import org.openqa.selenium.remote.server.handler.ChangeUrl;
import org.openqa.selenium.remote.server.handler.ClearElement;
import org.openqa.selenium.remote.server.handler.ClickElement;
import org.openqa.selenium.remote.server.handler.CloseWindow;
import org.openqa.selenium.remote.server.handler.ConfigureTimeout;
import org.openqa.selenium.remote.server.handler.DeleteCookie;
import org.openqa.selenium.remote.server.handler.DeleteNamedCookie;
import org.openqa.selenium.remote.server.handler.DeleteSession;
import org.openqa.selenium.remote.server.handler.DismissAlert;
import org.openqa.selenium.remote.server.handler.ElementEquality;
import org.openqa.selenium.remote.server.handler.ExecuteAsyncScript;
import org.openqa.selenium.remote.server.handler.ExecuteScript;
import org.openqa.selenium.remote.server.handler.FindActiveElement;
import org.openqa.selenium.remote.server.handler.FindChildElement;
import org.openqa.selenium.remote.server.handler.FindChildElements;
import org.openqa.selenium.remote.server.handler.FindElement;
import org.openqa.selenium.remote.server.handler.FindElements;
import org.openqa.selenium.remote.server.handler.GetAlertText;
import org.openqa.selenium.remote.server.handler.GetAllCookies;
import org.openqa.selenium.remote.server.handler.GetAllSessions;
import org.openqa.selenium.remote.server.handler.GetAllWindowHandles;
import org.openqa.selenium.remote.server.handler.GetAvailableLogTypesHandler;
import org.openqa.selenium.remote.server.handler.GetCssProperty;
import org.openqa.selenium.remote.server.handler.GetCurrentUrl;
import org.openqa.selenium.remote.server.handler.GetCurrentWindowHandle;
import org.openqa.selenium.remote.server.handler.GetElementAttribute;
import org.openqa.selenium.remote.server.handler.GetElementDisplayed;
import org.openqa.selenium.remote.server.handler.GetElementEnabled;
import org.openqa.selenium.remote.server.handler.GetElementLocation;
import org.openqa.selenium.remote.server.handler.GetElementLocationInView;
import org.openqa.selenium.remote.server.handler.GetElementSelected;
import org.openqa.selenium.remote.server.handler.GetElementSize;
import org.openqa.selenium.remote.server.handler.GetElementText;
import org.openqa.selenium.remote.server.handler.GetLogHandler;
import org.openqa.selenium.remote.server.handler.GetPageSource;
import org.openqa.selenium.remote.server.handler.GetScreenOrientation;
import org.openqa.selenium.remote.server.handler.GetSessionCapabilities;
import org.openqa.selenium.remote.server.handler.GetSessionLogsHandler;
import org.openqa.selenium.remote.server.handler.GetTagName;
import org.openqa.selenium.remote.server.handler.GetTitle;
import org.openqa.selenium.remote.server.handler.GetWindowPosition;
import org.openqa.selenium.remote.server.handler.GetWindowSize;
import org.openqa.selenium.remote.server.handler.GoBack;
import org.openqa.selenium.remote.server.handler.GoForward;
import org.openqa.selenium.remote.server.handler.ImeActivateEngine;
import org.openqa.selenium.remote.server.handler.ImeDeactivate;
import org.openqa.selenium.remote.server.handler.ImeGetActiveEngine;
import org.openqa.selenium.remote.server.handler.ImeGetAvailableEngines;
import org.openqa.selenium.remote.server.handler.ImeIsActivated;
import org.openqa.selenium.remote.server.handler.ImplicitlyWait;
import org.openqa.selenium.remote.server.handler.MaximizeWindow;
import org.openqa.selenium.remote.server.handler.NewSession;
import org.openqa.selenium.remote.server.handler.RefreshPage;
import org.openqa.selenium.remote.server.handler.Rotate;
import org.openqa.selenium.remote.server.handler.SendKeys;
import org.openqa.selenium.remote.server.handler.SetAlertText;
import org.openqa.selenium.remote.server.handler.SetScriptTimeout;
import org.openqa.selenium.remote.server.handler.SetWindowPosition;
import org.openqa.selenium.remote.server.handler.SetWindowSize;
import org.openqa.selenium.remote.server.handler.Status;
import org.openqa.selenium.remote.server.handler.SubmitElement;
import org.openqa.selenium.remote.server.handler.SwitchToFrame;
import org.openqa.selenium.remote.server.handler.SwitchToParentFrame;
import org.openqa.selenium.remote.server.handler.SwitchToWindow;
import org.openqa.selenium.remote.server.handler.UploadFile;
import org.openqa.selenium.remote.server.handler.html5.ClearLocalStorage;
import org.openqa.selenium.remote.server.handler.html5.ClearSessionStorage;
import org.openqa.selenium.remote.server.handler.html5.GetAppCacheStatus;
import org.openqa.selenium.remote.server.handler.html5.GetLocalStorageItem;
import org.openqa.selenium.remote.server.handler.html5.GetLocalStorageKeys;
import org.openqa.selenium.remote.server.handler.html5.GetLocalStorageSize;
import org.openqa.selenium.remote.server.handler.html5.GetLocationContext;
import org.openqa.selenium.remote.server.handler.html5.GetSessionStorageItem;
import org.openqa.selenium.remote.server.handler.html5.GetSessionStorageKeys;
import org.openqa.selenium.remote.server.handler.html5.GetSessionStorageSize;
import org.openqa.selenium.remote.server.handler.html5.RemoveLocalStorageItem;
import org.openqa.selenium.remote.server.handler.html5.RemoveSessionStorageItem;
import org.openqa.selenium.remote.server.handler.html5.SetLocalStorageItem;
import org.openqa.selenium.remote.server.handler.html5.SetLocationContext;
import org.openqa.selenium.remote.server.handler.html5.SetSessionStorageItem;
import org.openqa.selenium.remote.server.handler.interactions.ClickInSession;
import org.openqa.selenium.remote.server.handler.interactions.DoubleClickInSession;
import org.openqa.selenium.remote.server.handler.interactions.MouseDown;
import org.openqa.selenium.remote.server.handler.interactions.MouseMoveToLocation;
import org.openqa.selenium.remote.server.handler.interactions.MouseUp;
import org.openqa.selenium.remote.server.handler.interactions.SendKeyToActiveElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.DoubleTapOnElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.Down;
import org.openqa.selenium.remote.server.handler.interactions.touch.Flick;
import org.openqa.selenium.remote.server.handler.interactions.touch.LongPressOnElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.Move;
import org.openqa.selenium.remote.server.handler.interactions.touch.Scroll;
import org.openqa.selenium.remote.server.handler.interactions.touch.SingleTapOnElement;
import org.openqa.selenium.remote.server.handler.interactions.touch.Up;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultConfig;

public class JsonHttpCommandHandler {
    private static final String ADD_CONFIG_COMMAND_NAME = "-selenium-add-config";
    private final DriverSessions sessions;
    private final Logger log;
    private final JsonHttpCommandCodec commandCodec;
    private final JsonHttpResponseCodec responseCodec;
    private final Map<String, ResultConfig> configs = new LinkedHashMap<String, ResultConfig>();
    private final ErrorCodes errorCodes = new ErrorCodes();

    public JsonHttpCommandHandler(DriverSessions sessions, Logger log) {
        this.sessions = sessions;
        this.log = log;
        this.commandCodec = new JsonHttpCommandCodec();
        this.responseCodec = new JsonHttpResponseCodec();
        this.setUpMappings();
    }

    public void addNewMapping(String commandName, Class<? extends RestishHandler<?>> implementationClass) {
        ResultConfig config = new ResultConfig(commandName, implementationClass, this.sessions, this.log);
        this.configs.put(commandName, config);
    }

    public HttpResponse handleRequest(HttpRequest request) {
        Response response;
        block3: {
            this.log.fine(String.format("Handling: %s %s", request.getMethod(), request.getUri()));
            Command command = null;
            try {
                command = this.commandCodec.decode(request);
                ResultConfig config = this.configs.get(command.getName());
                if (config == null) {
                    throw new UnsupportedCommandException();
                }
                response = config.handle(command);
                this.log.fine(String.format("Finished: %s %s", request.getMethod(), request.getUri()));
            }
            catch (Exception e) {
                this.log.fine(String.format("Error on: %s %s", request.getMethod(), request.getUri()));
                response = new Response();
                response.setStatus(this.errorCodes.toStatusCode((Throwable)e));
                response.setState(this.errorCodes.toState(response.getStatus()));
                response.setValue((Object)e);
                if (command == null || command.getSessionId() == null) break block3;
                response.setSessionId(command.getSessionId().toString());
            }
        }
        return this.responseCodec.encode(response);
    }

    private void setUpMappings() {
        this.commandCodec.defineCommand(ADD_CONFIG_COMMAND_NAME, HttpMethod.POST, "/config/drivers");
        this.addNewMapping(ADD_CONFIG_COMMAND_NAME, AddConfig.class);
        this.addNewMapping("status", Status.class);
        this.addNewMapping("getAllSessions", GetAllSessions.class);
        this.addNewMapping("newSession", NewSession.class);
        this.addNewMapping("getCapabilities", GetSessionCapabilities.class);
        this.addNewMapping("quit", DeleteSession.class);
        this.addNewMapping("getCurrentWindowHandle", GetCurrentWindowHandle.class);
        this.addNewMapping("getWindowHandles", GetAllWindowHandles.class);
        this.addNewMapping("dismissAlert", DismissAlert.class);
        this.addNewMapping("acceptAlert", AcceptAlert.class);
        this.addNewMapping("getAlertText", GetAlertText.class);
        this.addNewMapping("setAlertValue", SetAlertText.class);
        this.addNewMapping("get", ChangeUrl.class);
        this.addNewMapping("getCurrentUrl", GetCurrentUrl.class);
        this.addNewMapping("goForward", GoForward.class);
        this.addNewMapping("goBack", GoBack.class);
        this.addNewMapping("refresh", RefreshPage.class);
        this.addNewMapping("executeScript", ExecuteScript.class);
        this.addNewMapping("executeAsyncScript", ExecuteAsyncScript.class);
        this.addNewMapping("getPageSource", GetPageSource.class);
        this.addNewMapping("screenshot", CaptureScreenshot.class);
        this.addNewMapping("getTitle", GetTitle.class);
        this.addNewMapping("findElement", FindElement.class);
        this.addNewMapping("findElements", FindElements.class);
        this.addNewMapping("getActiveElement", FindActiveElement.class);
        this.addNewMapping("findChildElement", FindChildElement.class);
        this.addNewMapping("findChildElements", FindChildElements.class);
        this.addNewMapping("clickElement", ClickElement.class);
        this.addNewMapping("getElementText", GetElementText.class);
        this.addNewMapping("submitElement", SubmitElement.class);
        this.addNewMapping("uploadFile", UploadFile.class);
        this.addNewMapping("sendKeysToElement", SendKeys.class);
        this.addNewMapping("getElementTagName", GetTagName.class);
        this.addNewMapping("clearElement", ClearElement.class);
        this.addNewMapping("isElementSelected", GetElementSelected.class);
        this.addNewMapping("isElementEnabled", GetElementEnabled.class);
        this.addNewMapping("isElementDisplayed", GetElementDisplayed.class);
        this.addNewMapping("getElementLocation", GetElementLocation.class);
        this.addNewMapping("getElementLocationOnceScrolledIntoView", GetElementLocationInView.class);
        this.addNewMapping("getElementSize", GetElementSize.class);
        this.addNewMapping("getElementValueOfCssProperty", GetCssProperty.class);
        this.addNewMapping("getElementAttribute", GetElementAttribute.class);
        this.addNewMapping("elementEquals", ElementEquality.class);
        this.addNewMapping("getCookies", GetAllCookies.class);
        this.addNewMapping("addCookie", AddCookie.class);
        this.addNewMapping("deleteAllCookies", DeleteCookie.class);
        this.addNewMapping("deleteCookie", DeleteNamedCookie.class);
        this.addNewMapping("switchToFrame", SwitchToFrame.class);
        this.addNewMapping("switchToParentFrame", SwitchToParentFrame.class);
        this.addNewMapping("switchToWindow", SwitchToWindow.class);
        this.addNewMapping("close", CloseWindow.class);
        this.addNewMapping("getWindowSize", GetWindowSize.class);
        this.addNewMapping("setWindowSize", SetWindowSize.class);
        this.addNewMapping("getWindowPosition", GetWindowPosition.class);
        this.addNewMapping("setWindowPosition", SetWindowPosition.class);
        this.addNewMapping("maximizeWindow", MaximizeWindow.class);
        this.addNewMapping("setTimeout", ConfigureTimeout.class);
        this.addNewMapping("implicitlyWait", ImplicitlyWait.class);
        this.addNewMapping("setScriptTimeout", SetScriptTimeout.class);
        this.addNewMapping("getLocation", GetLocationContext.class);
        this.addNewMapping("setLocation", SetLocationContext.class);
        this.addNewMapping("getStatus", GetAppCacheStatus.class);
        this.addNewMapping("getLocalStorageItem", GetLocalStorageItem.class);
        this.addNewMapping("removeLocalStorageItem", RemoveLocalStorageItem.class);
        this.addNewMapping("getLocalStorageKeys", GetLocalStorageKeys.class);
        this.addNewMapping("setLocalStorageItem", SetLocalStorageItem.class);
        this.addNewMapping("clearLocalStorage", ClearLocalStorage.class);
        this.addNewMapping("getLocalStorageSize", GetLocalStorageSize.class);
        this.addNewMapping("getSessionStorageItem", GetSessionStorageItem.class);
        this.addNewMapping("removeSessionStorageItem", RemoveSessionStorageItem.class);
        this.addNewMapping("getSessionStorageKey", GetSessionStorageKeys.class);
        this.addNewMapping("setSessionStorageItem", SetSessionStorageItem.class);
        this.addNewMapping("clearSessionStorage", ClearSessionStorage.class);
        this.addNewMapping("getSessionStorageSize", GetSessionStorageSize.class);
        this.addNewMapping("getScreenOrientation", GetScreenOrientation.class);
        this.addNewMapping("setScreenOrientation", Rotate.class);
        this.addNewMapping("mouseMoveTo", MouseMoveToLocation.class);
        this.addNewMapping("mouseClick", ClickInSession.class);
        this.addNewMapping("mouseDoubleClick", DoubleClickInSession.class);
        this.addNewMapping("mouseButtonDown", MouseDown.class);
        this.addNewMapping("mouseButtonUp", MouseUp.class);
        this.addNewMapping("sendKeysToActiveElement", SendKeyToActiveElement.class);
        this.addNewMapping("imeGetAvailableEngines", ImeGetAvailableEngines.class);
        this.addNewMapping("imeGetActiveEngine", ImeGetActiveEngine.class);
        this.addNewMapping("imeIsActivated", ImeIsActivated.class);
        this.addNewMapping("imeDeactivate", ImeDeactivate.class);
        this.addNewMapping("imeActivateEngine", ImeActivateEngine.class);
        this.addNewMapping("touchSingleTap", SingleTapOnElement.class);
        this.addNewMapping("touchDown", Down.class);
        this.addNewMapping("touchUp", Up.class);
        this.addNewMapping("touchMove", Move.class);
        this.addNewMapping("touchScroll", Scroll.class);
        this.addNewMapping("touchDoubleTap", DoubleTapOnElement.class);
        this.addNewMapping("touchLongPress", LongPressOnElement.class);
        this.addNewMapping("touchFlick", Flick.class);
        this.addNewMapping("getAvailableLogTypes", GetAvailableLogTypesHandler.class);
        this.addNewMapping("getLog", GetLogHandler.class);
        this.addNewMapping("getSessionLogs", GetSessionLogsHandler.class);
    }
}

