/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.servlet.ConsoleServlet;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.DriverServlet;
import org.openqa.grid.web.servlet.Grid1HeartbeatServlet;
import org.openqa.grid.web.servlet.HubStatusServlet;
import org.openqa.grid.web.servlet.LifecycleServlet;
import org.openqa.grid.web.servlet.ProxyStatusServlet;
import org.openqa.grid.web.servlet.RegistrationServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.servlet.TestSessionStatusServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.server.log.LoggingOptions;
import org.openqa.selenium.remote.server.log.TerseFormatter;
import org.seleniumhq.jetty7.server.Connector;
import org.seleniumhq.jetty7.server.Server;
import org.seleniumhq.jetty7.server.bio.SocketConnector;
import org.seleniumhq.jetty7.servlet.ServletContextHandler;

public class Hub {
    private static final Logger log = Logger.getLogger(Hub.class.getName());
    private final int port;
    private final String host;
    private final Registry registry;
    private final Map<String, Class<? extends Servlet>> extraServlet = Maps.newHashMap();
    private Server server;

    private void addServlet(String key, Class<? extends Servlet> s) {
        this.extraServlet.put(key, s);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Hub(GridHubConfiguration config) {
        String logFilename;
        Level logLevel = config.isDebug() ? Level.FINE : Level.INFO;
        Logger.getLogger("").setLevel(logLevel);
        for (Handler handler : Logger.getLogger("").getHandlers()) {
            Logger.getLogger("").removeHandler(handler);
        }
        String string = logFilename = config.getLogFilename() == null ? LoggingOptions.getDefaultLogOutFile() : config.getLogFilename();
        if (logFilename != null) {
            try {
                FileHandler logFile = new FileHandler(new File(logFilename).getAbsolutePath(), true);
                logFile.setFormatter(new TerseFormatter(true));
                logFile.setLevel(logLevel);
                Logger.getLogger("").addHandler(logFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            ConsoleHandler console = new ConsoleHandler();
            console.setLevel(logLevel);
            Logger.getLogger("").addHandler(console);
        }
        this.registry = Registry.newInstance(this, config);
        if (config.getHost() != null) {
            this.host = config.getHost();
        } else {
            NetworkUtils utils = new NetworkUtils();
            this.host = utils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        }
        this.port = config.getPort();
        for (String s : config.getServlets()) {
            Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
            if (servletClass == null) continue;
            String path = "/grid/admin/" + servletClass.getSimpleName() + "/*";
            log.info("binding " + servletClass.getCanonicalName() + " to " + path);
            this.addServlet(path, servletClass);
        }
        this.initServer();
    }

    private void initServer() {
        try {
            this.server = new Server();
            SocketConnector socketListener = new SocketConnector();
            socketListener.setMaxIdleTime(60000);
            socketListener.setPort(this.port);
            this.server.addConnector((Connector)socketListener);
            ServletContextHandler root = new ServletContextHandler(1);
            root.setContextPath("/");
            this.server.setHandler((org.seleniumhq.jetty7.server.Handler)root);
            root.setAttribute(Registry.KEY, (Object)this.registry);
            root.addServlet(DisplayHelpServlet.class.getName(), "/*");
            root.addServlet(ConsoleServlet.class.getName(), "/grid/console/*");
            root.addServlet(org.openqa.grid.web.servlet.beta.ConsoleServlet.class.getName(), "/grid/beta/console/*");
            root.addServlet(RegistrationServlet.class.getName(), "/grid/register/*");
            root.addServlet(DriverServlet.class.getName(), "/grid/driver/*");
            root.addServlet(DriverServlet.class.getName(), "/wd/hub/*");
            root.addServlet(DriverServlet.class.getName(), "/selenium-server/driver/*");
            root.addServlet(ResourceServlet.class.getName(), "/grid/resources/*");
            root.addServlet(ProxyStatusServlet.class.getName(), "/grid/api/proxy/*");
            root.addServlet(HubStatusServlet.class.getName(), "/grid/api/hub/*");
            root.addServlet(TestSessionStatusServlet.class.getName(), "/grid/api/testsession/*");
            root.addServlet(LifecycleServlet.class.getName(), "/lifecycle-manager/*");
            root.addServlet(RegistrationServlet.class.getName(), "/registration-manager/register/*");
            root.addServlet(Grid1HeartbeatServlet.class.getName(), "/heartbeat");
            for (Map.Entry<String, Class<? extends Servlet>> entry : this.extraServlet.entrySet()) {
                root.addServlet(entry.getValue().getName(), entry.getKey());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing the hub" + e.getMessage(), e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void start() throws Exception {
        this.initServer();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public URL getUrl() {
        try {
            return new URL("http://" + this.getHost() + ":" + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getRegistrationURL() {
        String uri = "http://" + this.getHost() + ":" + this.getPort() + "/grid/register/";
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

