/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteControlConfiguration;

public class MockBrowserLauncher
implements BrowserLauncher,
Runnable {
    private static final String DANGEROUS_TEXT = "&%?\\+|,%*";
    private static final String JAPANESE_TEXT = "\u307e\u3077";
    private static final String CHINESE_TEXT = "\u4e2d\u6587";
    private static final String KOREAN_TEXT = "\uc5f4\uc5d0";
    private static final String ROMANCE_TEXT = "\u00fc\u00f6\u00e4\u00dc\u00d6\u00c4 \u00e7\u00e8\u00e9 \u00bf\u00f1 \u00e8\u00e0\u00f9\u00f2";
    static Logger log = Logger.getLogger(MockBrowserLauncher.class.getName());
    private final String sessionId;
    private Thread browser;
    private volatile boolean interrupted = false;
    private final String uniqueId;
    private int sequenceNumber = 0;
    private final RemoteControlConfiguration configuration;
    private final Capabilities browserOptions;

    public MockBrowserLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String command) {
        this.sessionId = sessionId;
        this.uniqueId = "mock";
        this.configuration = configuration;
        this.browserOptions = browserOptions;
    }

    public void launchHTMLSuite(String startURL, String suiteUrl) {
    }

    public void close() {
        this.interrupted = true;
        this.browser.interrupt();
    }

    @Override
    public void run() {
        try {
            String startURL = "http://localhost:" + this.configuration.getPortDriversShouldContact() + "/selenium-server/driver/?sessionId=" + this.sessionId + "&uniqueId=" + this.uniqueId;
            String commandLine = this.doBrowserRequest(startURL + "&seleniumStart=true&sequenceNumber=" + this.sequenceNumber++, "START");
            while (!this.interrupted) {
                log.info("MOCK: " + commandLine);
                RemoteCommand sc = DefaultRemoteCommand.parse(commandLine);
                String result = this.doCommand(sc);
                if (this.browserOptions.is("browserSideLog") && !this.interrupted) {
                    for (int i = 0; i < 3; ++i) {
                        this.doBrowserRequest(startURL + "&logging=true&sequenceNumber=" + this.sequenceNumber++, "logLevel=debug:dummy log message " + i + "\n");
                    }
                }
                if (this.interrupted) continue;
                commandLine = this.doBrowserRequest(startURL + "&sequenceNumber=" + this.sequenceNumber++, result);
            }
            log.info("MOCK: interrupted, exiting");
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Exception in mock browser", e);
            re.printStackTrace();
            throw re;
        }
    }

    private String doCommand(RemoteCommand sc) {
        String command = sc.getCommand();
        if (command.equals("getAllButtons")) {
            return "OK,";
        }
        if (command.equals("getAllLinks")) {
            return "OK,1";
        }
        if (command.equals("getAllFields")) {
            return "OK,1,2,3";
        }
        if (command.equals("getWhetherThisFrameMatchFrameExpression")) {
            return "OK,true";
        }
        if ("dangerous-labels".equals(sc.getField()) && command.equals("getSelectOptions")) {
            return "OK,veni\\, vidi\\, vici,c:\\\\foo\\\\bar,c:\\\\I came\\, I \\\\saw\\\\\\, I conquered";
        }
        if (command.startsWith("getText")) {
            if ("romance".equals(sc.getField())) {
                return "OK,\u00fc\u00f6\u00e4\u00dc\u00d6\u00c4 \u00e7\u00e8\u00e9 \u00bf\u00f1 \u00e8\u00e0\u00f9\u00f2";
            }
            if ("korean".equals(sc.getField())) {
                return "OK,\uc5f4\uc5d0";
            }
            if ("chinese".equals(sc.getField())) {
                return "OK,\u4e2d\u6587";
            }
            if ("japanese".equals(sc.getField())) {
                return "OK,\u307e\u3077";
            }
            if ("dangerous".equals(sc.getField())) {
                return "OK,&%?\\+|,%*";
            }
        } else {
            if (command.startsWith("get")) {
                return "OK,x";
            }
            if (command.startsWith("isTextPresent")) {
                if (ROMANCE_TEXT.equals(sc.getField())) {
                    return "OK,true";
                }
                if (KOREAN_TEXT.equals(sc.getField())) {
                    return "OK,true";
                }
                if (CHINESE_TEXT.equals(sc.getField())) {
                    return "OK,true";
                }
                if (JAPANESE_TEXT.equals(sc.getField())) {
                    return "OK,true";
                }
                if (DANGEROUS_TEXT.equals(sc.getField())) {
                    return "OK,true";
                }
                return "OK,false";
            }
            if (command.startsWith("is")) {
                return "OK,true";
            }
        }
        return "OK";
    }

    private String stringContentsOfInputStream(InputStream is) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is, "UTF-8");
        while ((c = r.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private String doBrowserRequest(String url, String body) throws IOException {
        int responsecode = 200;
        URL result = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)result.openConnection();
        conn.setRequestProperty("Content-Type", "application/xml");
        conn.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
        wr.write(body);
        wr.flush();
        wr.close();
        if (responsecode == 301) {
            String pathToServlet = conn.getRequestProperty("Location");
            throw new RuntimeException("Bug! 301 redirect??? " + pathToServlet);
        }
        if (responsecode != 200) {
            throw new RuntimeException(conn.getResponseMessage());
        }
        InputStream is = conn.getInputStream();
        return this.stringContentsOfInputStream(is);
    }

    public void launchRemoteSession(String url) {
        this.browser = new Thread(this);
        this.browser.setName("mockbrowser");
        if (null != url) {
            this.browser.start();
        } else {
            log.info("launching a mock unresponsive browser");
        }
    }
}

