/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.internal.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.jetty.jetty.servlet.ServletHttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverRequestHandler
extends RequestHandler {
    private static final Logger log = Logger.getLogger(WebDriverRequestHandler.class.getName());

    protected WebDriverRequestHandler(HttpServletRequest request, HttpServletResponse response, Registry registry) {
        super(request, response, registry);
    }

    @Override
    public RequestType extractRequestType() {
        if ("/session".equals(this.getRequest().getPathInfo())) {
            return RequestType.START_SESSION;
        }
        if (this.getRequest().getMethod().equalsIgnoreCase("DELETE")) {
            String externalKey = this.extractSession(this.getRequest().getPathInfo());
            if (this.getRequest().getPathInfo().endsWith("/session/" + externalKey)) {
                return RequestType.STOP_SESSION;
            }
        }
        return RequestType.REGULAR;
    }

    @Override
    public String extractSession() {
        if (this.getRequestType() == RequestType.START_SESSION) {
            throw new IllegalAccessError("Cannot call that method of a new session request.");
        }
        String path = this.getRequest().getPathInfo();
        return this.extractSession(path);
    }

    private String extractSession(String path) {
        int sessionIndex = path.indexOf("/session/");
        if (sessionIndex != -1) {
            String session;
            int nextSlash = path.indexOf("/", sessionIndex += "/session/".length());
            if ("".equals(session = nextSlash != -1 ? path.substring(sessionIndex, nextSlash) : path.substring(sessionIndex, path.length()))) {
                return null;
            }
            return session;
        }
        return null;
    }

    @Override
    public Map<String, Object> extractDesiredCapability() {
        String json = this.getRequestBody();
        HashMap<String, Object> desiredCapability = new HashMap<String, Object>();
        try {
            JSONObject map = new JSONObject(json);
            JSONObject dc = map.getJSONObject("desiredCapabilities");
            Iterator iterator = dc.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = dc.get(key);
                if (value == JSONObject.NULL) {
                    value = null;
                }
                desiredCapability.put(key, value);
            }
        }
        catch (JSONException e) {
            throw new GridException("Cannot extract a capabilities from the request " + json);
        }
        return desiredCapability;
    }

    @Override
    public String forwardNewSessionRequest(TestSession session) {
        try {
            JSONObject c = new JSONObject();
            c.put("desiredCapabilities", session.getRequestedCapabilities());
            String content = c.toString();
            session.forward(this.getRequest(), this.getResponse(), content, false);
        }
        catch (IOException e) {
            log.warning("Error forwarding the request " + e.getMessage());
            return null;
        }
        catch (JSONException e) {
            log.warning("Error with the request " + e.getMessage());
            return null;
        }
        if (this.getResponse().containsHeader("Location")) {
            String location = ((ServletHttpResponse)this.getResponse()).getHttpResponse().getField("Location");
            return this.extractSession(location);
        }
        log.warning("Error, header should contain Location");
        return null;
    }
}

