/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.server.IOHelper;
import org.openqa.selenium.server.commands.CaptureScreenshotToStringCommand;
import org.openqa.selenium.server.commands.Command;
import org.openqa.selenium.server.commands.SeleniumCoreCommand;

public class CaptureEntirePageScreenshotToStringCommand
extends Command {
    public static final String ID = "captureEntirePageScreenshotToString";
    private static final Logger log = Logger.getLogger(CaptureScreenshotToStringCommand.class.getName());
    private final String kwargs;
    private final String sessionId;

    public CaptureEntirePageScreenshotToStringCommand(String kwargs, String sessionId) {
        this.kwargs = kwargs;
        this.sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        String string;
        InputStream inputStream = null;
        String filePath = this.screenshotFilePath();
        log.fine("Capturing page screenshot for session " + this.sessionId + " under '" + filePath + "'");
        this.capturePageScreenshot(filePath);
        try {
            string = "OK," + new Base64Encoder().encode(IOHelper.readFile(filePath));
            Object var6_5 = null;
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = "ERROR: " + e;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                IOHelper.close(inputStream);
                throw throwable;
            }
            IOHelper.close(inputStream);
            return string2;
        }
        IOHelper.close(inputStream);
        return string;
    }

    public String capturePageScreenshot(String filePath) {
        ArrayList<String> args = new ArrayList<String>(2);
        args.add(filePath);
        args.add(this.kwargs);
        SeleniumCoreCommand pageScreenshotCommand = new SeleniumCoreCommand("captureEntirePageScreenshot", args, this.sessionId);
        pageScreenshotCommand.execute();
        return null;
    }

    public String screenshotFilePath() {
        File screenshotDir = this.screenshotDirectory();
        return screenshotDir + "/page-screenshot-" + this.sessionId + ".png";
    }

    public File screenshotDirectory() {
        File screenshotDir = new File(LauncherUtils.customProfileDir((String)this.sessionId), "screenshots");
        if (!screenshotDir.exists()) {
            screenshotDir.mkdirs();
        }
        return screenshotDir;
    }
}

