/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class ActiveTestSessions {
    private static final Logger log = Logger.getLogger(ActiveTestSessions.class.getName());
    private final Set<TestSession> activeTestSessions = new CopyOnWriteArraySet<TestSession>();
    private final Queue<ExternalSessionKey> terminatedSessions = new ConcurrentLinkedQueue<ExternalSessionKey>();
    private final Map<ExternalSessionKey, SessionTerminationReason> reasons = new ConcurrentHashMap<ExternalSessionKey, SessionTerminationReason>();

    ActiveTestSessions() {
    }

    public boolean add(TestSession testSession) {
        boolean added = this.activeTestSessions.add(testSession);
        if (!added) {
            log.severe("Error adding session : " + testSession);
        }
        return added;
    }

    public boolean remove(TestSession o, SessionTerminationReason reason) {
        this.updateReason(o, reason);
        return this.activeTestSessions.remove(o);
    }

    private void updateReason(TestSession o, SessionTerminationReason reason) {
        if (o.getExternalKey() == null) {
            if (SessionTerminationReason.CREATIONFAILED != reason) {
                log.info("Removed a session that had not yet assigned an external key " + o.getInternalKey() + ", indicates failure in session creation " + (Object)((Object)reason));
            }
            return;
        }
        this.terminatedSessions.add(o.getExternalKey());
        this.reasons.put(o.getExternalKey(), reason);
        if (this.reasons.size() > 10000) {
            ExternalSessionKey remove = this.terminatedSessions.remove();
            this.reasons.remove(remove);
        }
    }

    public TestSession findSessionByInternalKey(String internalKey) {
        if (internalKey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!internalKey.equals(session.getInternalKey())) continue;
            return session;
        }
        return null;
    }

    public TestSession getExistingSession(ExternalSessionKey externalkey) {
        TestSession sessionByExternalKey = this.findSessionByExternalKey(externalkey);
        if (sessionByExternalKey == null) {
            String keyId;
            SessionTerminationReason sessionTerminationReason = this.reasons.get(externalkey);
            String string = keyId = externalkey != null ? externalkey.getKey() : "(null externalkey)";
            if (sessionTerminationReason != null) {
                log.warning("Client requested session " + keyId + " that was terminated due to " + (Object)((Object)sessionTerminationReason));
            } else {
                log.info("Client requested an externalKey " + keyId + " that is not among the last 10000 active sessions");
            }
        }
        return sessionByExternalKey;
    }

    public TestSession findSessionByExternalKey(ExternalSessionKey externalkey) {
        if (externalkey == null) {
            return null;
        }
        for (TestSession session : this.activeTestSessions) {
            if (!externalkey.equals(session.getExternalKey())) continue;
            return session;
        }
        return null;
    }

    public Set<TestSession> unmodifiableSet() {
        return Collections.unmodifiableSet(this.activeTestSessions);
    }
}

