/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions.touch;

import java.util.Map;
import org.openqa.selenium.HasTouchScreen;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scroll
extends WebElementHandler
implements JsonParametersAware {
    private static final String ELEMENT = "element";
    private static final String XOFFSET = "xoffset";
    private static final String YOFFSET = "yoffset";
    String elementId;
    int xOffset;
    int yOffset;

    public Scroll(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        TouchScreen touchScreen = ((HasTouchScreen)this.getDriver()).getTouch();
        if (this.elementId != null) {
            WebElement element = this.getKnownElements().get(this.elementId);
            Coordinates elementLocation = ((Locatable)element).getCoordinates();
            touchScreen.scroll(elementLocation, this.xOffset, this.yOffset);
        } else {
            touchScreen.scroll(this.xOffset, this.yOffset);
        }
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[scroll: %s]", this.elementId);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters.containsKey(ELEMENT)) {
            this.elementId = (String)allParameters.get(ELEMENT);
        }
        this.xOffset = ((Long)allParameters.get(XOFFSET)).intValue();
        this.yOffset = ((Long)allParameters.get(YOFFSET)).intValue();
    }
}

