/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.Selenium1RequestHandler;
import org.openqa.grid.web.servlet.handler.WebDriverRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestHandler
implements Comparable<RequestHandler> {
    private final Registry registry;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String body = null;
    private boolean bodyHasBeenRead = false;
    private volatile Map<String, Object> desiredCapabilities = null;
    private RequestType requestType = null;
    private volatile TestSession session = null;
    private final CountDownLatch sessionAssigned = new CountDownLatch(1);
    private static final Logger log = Logger.getLogger(RequestHandler.class.getName());
    private final Thread waitingThread;

    public static RequestHandler createHandler(HttpServletRequest request, HttpServletResponse response, Registry registry) {
        if (RequestHandler.isSeleniumProtocol(request)) {
            return new Selenium1RequestHandler(request, response, registry);
        }
        return new WebDriverRequestHandler(request, response, registry);
    }

    protected RequestHandler(HttpServletRequest request, HttpServletResponse response, Registry registry) {
        this.request = request;
        this.response = response;
        this.registry = registry;
        this.waitingThread = Thread.currentThread();
    }

    public abstract RequestType extractRequestType();

    public abstract ExternalSessionKey extractSession();

    public abstract Map<String, Object> extractDesiredCapability();

    public abstract ExternalSessionKey forwardNewSessionRequest(TestSession var1) throws NewSessionException;

    protected void forwardRequest(TestSession session, RequestHandler handler) throws IOException {
        if (this.bodyHasBeenRead) {
            session.forward(this.request, this.response, this.getRequestBody(), false);
        } else {
            session.forward(this.request, this.response);
        }
    }

    public void process() {
        switch (this.getRequestType()) {
            case START_SESSION: {
                try {
                    this.registry.addNewSessionRequest(this);
                    this.waitForSessionBound();
                    this.beforeSessionEvent();
                    this.forwardAndGetRemoteKey();
                    break;
                }
                catch (Exception e) {
                    this.cleanup();
                    throw new GridException("Error forwarding the new session " + e.getMessage(), e);
                }
            }
            case REGULAR: 
            case STOP_SESSION: {
                this.session = this.getSession();
                if (this.session == null) {
                    ExternalSessionKey sessionKey = null;
                    try {
                        sessionKey = this.extractSession();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    throw new GridException("Session [" + sessionKey + "] not available - " + this.registry.getActiveSessions());
                }
                try {
                    this.forwardRequest(this.session, this);
                }
                catch (Throwable t) {
                    log.log(Level.SEVERE, "cannot forward the request " + t.getMessage(), t);
                    this.registry.terminate(this.session);
                    throw new GridException("cannot forward the request " + t.getMessage(), t);
                }
                if (this.getRequestType() != RequestType.STOP_SESSION) break;
                this.registry.terminate(this.session);
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }

    private void cleanup() {
        this.registry.removeNewSessionRequest(this);
        if (this.session != null) {
            this.registry.terminate(this.session);
        }
    }

    private void forwardAndGetRemoteKey() throws NewSessionException {
        ExternalSessionKey externalKey = this.forwardNewSessionRequest(this.session);
        if (externalKey == null) {
            throw new NewSessionException("Error forwarding the new session request.external key should never be null");
        }
        this.session.setExternalKey(externalKey);
    }

    private void beforeSessionEvent() throws NewSessionException {
        RemoteProxy p = this.session.getSlot().getProxy();
        if (p instanceof TestSessionListener) {
            try {
                ((TestSessionListener)((Object)p)).beforeSession(this.session);
            }
            catch (Exception e) {
                log.severe("Error running the beforeSessionListener : " + e.getMessage());
                e.printStackTrace();
                throw new NewSessionException("The listener threw an exception ( listener bug )", e);
            }
        }
    }

    public void waitForSessionBound() throws InterruptedException, TimeoutException {
        if (this.registry.getNewSessionWaitTimeout() != -1) {
            if (!this.sessionAssigned.await(this.registry.getNewSessionWaitTimeout(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Request timed out waiting for a node to become available.");
            }
        } else {
            this.sessionAssigned.await();
        }
    }

    private static boolean isSeleniumProtocol(HttpServletRequest request) {
        return "/selenium-server/driver".equals(request.getServletPath());
    }

    protected String getRequestBody() {
        if (!this.bodyHasBeenRead) {
            this.bodyHasBeenRead = true;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                ServletInputStream is = this.request.getInputStream();
                if (is == null) {
                    return null;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                is.close();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.body = sb.toString();
        }
        return this.body;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Map<String, Object> getDesiredCapabilities() {
        if (this.desiredCapabilities == null) {
            this.desiredCapabilities = this.extractDesiredCapability();
        }
        return this.desiredCapabilities;
    }

    protected void setDesiredCapabilities(Map<String, Object> desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }

    @Override
    public int compareTo(RequestHandler o) {
        Prioritizer prioritizer = this.registry.getPrioritizer();
        if (prioritizer != null) {
            return prioritizer.compareTo(this.getDesiredCapabilities(), o.getDesiredCapabilities());
        }
        return 0;
    }

    protected RequestType getRequestType() {
        if (this.requestType == null) {
            this.requestType = this.extractRequestType();
        }
        return this.requestType;
    }

    protected void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    protected void setSession(TestSession session) {
        this.session = session;
    }

    public void bindSession(TestSession session) {
        this.session = session;
        this.sessionAssigned.countDown();
    }

    protected TestSession getSession() {
        if (this.session == null) {
            ExternalSessionKey externalKey = this.extractSession();
            this.session = this.registry.getSession(externalKey);
            if (this.session == null) {
                log.warning("Cannot find session " + externalKey + " in the registry.");
            }
        }
        return this.session;
    }

    public ExternalSessionKey getServerSession() {
        if (this.session == null) {
            return null;
        }
        return this.session.getExternalKey();
    }

    public void stop() {
        this.waitingThread.interrupt();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("session :").append(this.session).append(" , ");
        b.append("cap : ").append(this.getDesiredCapabilities());
        b.append("\n");
        return b.toString();
    }

    public String debug() {
        StringBuilder b = new StringBuilder();
        b.append("\nmethod: ").append(this.request.getMethod());
        b.append("\npathInfo: ").append(this.request.getPathInfo());
        b.append("\nuri: ").append(this.request.getRequestURI());
        b.append("\ncontent :").append(this.getRequestBody());
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHandler other = (RequestHandler)obj;
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

