/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import java.net.URL;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.selenium.SelfRegisteringRemote;
import org.openqa.grid.selenium.utils.GridConfiguration;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.RemoteControlConfiguration;

public class SelfRegisteringSelenium
extends SelfRegisteringRemote {
    private static final String REMOTE_PATH = "/selenium-server/driver";
    RemoteControlConfiguration config = null;

    public SelfRegisteringSelenium(GridConfiguration config) {
        super(config);
    }

    public URL getRemoteURL() {
        String url = "http://" + this.getGridConfig().getHost() + ":" + this.getGridConfig().getNodeRemoteControlConfiguration().getPort() + REMOTE_PATH;
        try {
            return new URL(url);
        }
        catch (Throwable e) {
            throw new RuntimeException("URL for the node doesn't seem correct: " + url + " , " + e.getMessage());
        }
    }

    public RegistrationRequest getRegistrationRequest() {
        RegistrationRequest request = super.getRegistrationRequest();
        request.getConfiguration().put("proxy", "org.openqa.grid.selenium.proxy.SeleniumRemoteProxy");
        return request;
    }

    public void addFirefoxSupport() {
        DesiredCapabilities ff = new DesiredCapabilities();
        ff.setBrowserName("*firefox");
        ff.setCapability("platform", Platform.getCurrent());
        this.getGridConfig().getCapabilities().add(ff);
    }

    public void addInternetExplorerSupport() {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            DesiredCapabilities ie = new DesiredCapabilities();
            ie.setBrowserName("*iexplore");
            this.getGridConfig().getCapabilities().add(ie);
        }
    }

    public void addSafariSupport() {
        DesiredCapabilities safari = new DesiredCapabilities();
        safari.setBrowserName("*safari");
        this.getGridConfig().getCapabilities().add(safari);
    }
}

