/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.selenium.SelfRegisteringSelenium;
import org.openqa.grid.selenium.SelfRegisteringWebDriver;
import org.openqa.grid.selenium.utils.GridConfiguration;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.server.SeleniumServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelfRegisteringRemote {
    private GridConfiguration gridConfig;
    private Map<String, Object> config = new HashMap<String, Object>();
    SeleniumServer server;

    public SelfRegisteringRemote(GridConfiguration config) {
        this.gridConfig = config;
        this.setMaxConcurrentSession(config.getMaxConcurrentTests());
        this.setTimeout(config.getNodeTimeoutInSec() * 1000, 10000L);
    }

    public static SelfRegisteringRemote create(GridConfiguration config) {
        switch (config.getRole()) {
            case REMOTE_CONTROL: {
                return new SelfRegisteringSelenium(config);
            }
            case WEBDRIVER: {
                return new SelfRegisteringWebDriver(config);
            }
        }
        throw new RuntimeException("NI");
    }

    public abstract URL getRemoteURL();

    public void launchRemoteServer() throws Exception {
        this.server = new SeleniumServer(this.getGridConfig().getNodeRemoteControlConfiguration());
        this.server.boot();
    }

    public void stopRemoteServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void setMaxConcurrentSession(int max) {
        this.getConfig().put("maxSession", max);
    }

    public void addCustomBrowser(DesiredCapabilities cap) {
        String s = cap.getBrowserName();
        if (s == null || "".equals(s)) {
            throw new InvalidParameterException(cap + " does seems to be a valid browser.");
        }
        cap.setPlatform(Platform.getCurrent());
        this.getGridConfig().getCapabilities().add(cap);
    }

    public abstract void addInternetExplorerSupport();

    public abstract void addSafariSupport();

    public abstract void addFirefoxSupport();

    public void addChromeSupport() {
        DesiredCapabilities chrome = new DesiredCapabilities("chrome", "10.0", Platform.getCurrent());
        this.getGridConfig().getCapabilities().add(chrome);
    }

    public void setTimeout(long timeoutMillis, long cycleMillis) {
        this.config.put("timeout", timeoutMillis);
        this.config.put("cleanUpCycle", cycleMillis);
    }

    public RegistrationRequest getRegistrationRequest() {
        RegistrationRequest request = new RegistrationRequest();
        for (DesiredCapabilities cap : this.getGridConfig().getCapabilities()) {
            request.addDesiredCapabilitiy(cap.asMap());
        }
        this.config.put("url", this.getRemoteURL());
        request.setConfiguration(this.config);
        return request;
    }

    public void registerToHub() {
        try {
            BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("POST", this.gridConfig.getRegistrationURL().toExternalForm());
            r.setEntity((HttpEntity)new StringEntity(this.getRegistrationRequest().toJSON()));
            DefaultHttpClient client = new DefaultHttpClient();
            HttpHost host = new HttpHost(this.gridConfig.getRegistrationURL().getHost(), this.gridConfig.getRegistrationURL().getPort());
            HttpResponse response = client.execute(host, (HttpRequest)r);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Error sending the registration request.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error sending the registration request.", e);
        }
    }

    public GridConfiguration getGridConfig() {
        return this.gridConfig;
    }

    Map<String, Object> getConfig() {
        return this.config;
    }
}

