/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HashUserRealm;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.SecurityConstraint;
import org.openqa.jetty.http.SocketListener;
import org.openqa.jetty.http.handler.SecurityHandler;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.jetty.servlet.ServletHandler;
import org.openqa.jetty.util.MultiException;
import org.openqa.selenium.browserlaunchers.AsyncExecute;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.server.DefaultDriverSessions;
import org.openqa.selenium.remote.server.DriverServlet;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.CachedContentTestHandler;
import org.openqa.selenium.server.ClasspathResourceLocator;
import org.openqa.selenium.server.FsResourceLocator;
import org.openqa.selenium.server.InjectionHelper;
import org.openqa.selenium.server.ProxyHandler;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumDriverResourceHandler;
import org.openqa.selenium.server.SessionExtensionJsHandler;
import org.openqa.selenium.server.SslCertificateGenerator;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.cli.RemoteControlLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.SeleniumHTMLRunnerResultsHandler;
import org.openqa.selenium.server.htmlrunner.SingleTestSuiteResourceHandler;
import org.openqa.selenium.server.log.LoggingManager;

public class SeleniumServer
implements SslCertificateGenerator {
    private Log LOGGER;
    private Server server;
    private SeleniumDriverResourceHandler driver;
    private SeleniumHTMLRunnerResultsHandler postResultsHandler;
    private StaticContentHandler staticContentHandler;
    private final RemoteControlConfiguration configuration;
    private Thread shutDownHook;
    private static final NetworkUtils networkUtils = new NetworkUtils();
    private static ProxyHandler customProxyHandler;
    private ProxyHandler proxyHandler;
    public static int DEFAULT_JETTY_THREADS;
    private int jettyThreads = DEFAULT_JETTY_THREADS;
    private boolean debugMode = false;
    private final Object shutdownLock = new Object();
    private static final int MAX_SHUTDOWN_RETRIES = 8;

    public static void main(String[] args) throws Exception {
        RemoteControlConfiguration configuration = RemoteControlLauncher.parseLauncherOptions(args);
        SeleniumServer.checkArgsSanity(configuration);
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        SeleniumServer seleniumProxy = new SeleniumServer(SeleniumServer.slowResourceProperty(), configuration);
        seleniumProxy.boot();
    }

    public SeleniumServer() throws Exception {
        this(SeleniumServer.slowResourceProperty(), new RemoteControlConfiguration());
    }

    public SeleniumServer(RemoteControlConfiguration configuration) throws Exception {
        this(SeleniumServer.slowResourceProperty(), configuration);
    }

    public SeleniumServer(boolean slowResources) throws Exception {
        this(slowResources, new RemoteControlConfiguration());
    }

    public SeleniumServer(boolean slowResources, RemoteControlConfiguration configuration) throws Exception {
        this.configuration = configuration;
        this.debugMode = configuration.isDebugMode();
        this.jettyThreads = configuration.getJettyThreads();
        this.LOGGER = LoggingManager.configureLogging(configuration, this.debugMode);
        this.logStartupInfo();
        this.sanitizeProxyConfiguration();
        this.createJettyServer(slowResources);
        configuration.setSeleniumServer(this);
    }

    public void boot() throws Exception {
        this.start();
        if (null != this.configuration.getUserExtensions()) {
            this.addNewStaticContent(this.configuration.getUserExtensions().getParentFile());
        }
        if (this.configuration.isHTMLSuite()) {
            this.runHtmlSuite();
            return;
        }
        if (this.configuration.isInteractive()) {
            this.readUserCommands();
        }
    }

    protected void createJettyServer(boolean slowResources) {
        this.server = new Server();
        SocketListener socketListener = new SocketListener();
        socketListener.setMaxIdleTimeMs(60000);
        socketListener.setMaxThreads(this.jettyThreads);
        socketListener.setPort(this.getPort());
        this.server.addListener(socketListener);
        this.assembleHandlers(slowResources, this.configuration);
    }

    private void logVersionNumber() throws IOException {
        Properties p = new Properties();
        InputStream stream = LauncherUtils.getSeleniumResourceAsStream((String)"/VERSION.txt");
        if (stream == null) {
            this.LOGGER.error((Object)"Couldn't determine version number");
            return;
        }
        p.load(stream);
        String rcVersion = p.getProperty("selenium.rc.version");
        String rcRevision = p.getProperty("selenium.rc.revision");
        String coreVersion = p.getProperty("selenium.core.version");
        String coreRevision = p.getProperty("selenium.core.revision");
        this.LOGGER.info((Object)("v" + rcVersion + " [" + rcRevision + "], with Core v" + coreVersion + " [" + coreRevision + "]"));
    }

    private void assembleHandlers(boolean slowResources, RemoteControlConfiguration configuration) {
        this.server.addContext(this.createRootContextWithProxyHandler(configuration));
        HttpContext context = new HttpContext();
        context.setContextPath("/selenium-server");
        context.setMimeMapping("xhtml", "application/xhtml+xml");
        this.addSecurityHandler(context);
        this.addStaticContentHandler(slowResources, configuration, context);
        context.addHandler(new SessionExtensionJsHandler());
        context.addHandler(new SingleTestSuiteResourceHandler());
        this.postResultsHandler = new SeleniumHTMLRunnerResultsHandler();
        context.addHandler(this.postResultsHandler);
        context.addHandler(new CachedContentTestHandler());
        this.server.addContext(context);
        this.server.addContext(this.createDriverContextWithSeleniumDriverResourceHandler(context));
        this.server.addContext(this.createWebDriverRemoteContext());
    }

    private HttpContext createDriverContextWithSeleniumDriverResourceHandler(HttpContext context) {
        HttpContext driverContext = new HttpContext();
        driverContext.setContextPath("/selenium-server/driver");
        this.driver = new SeleniumDriverResourceHandler(this);
        context.addHandler(this.driver);
        return driverContext;
    }

    private HttpContext createWebDriverRemoteContext() {
        HttpContext webdriverContext = new HttpContext();
        webdriverContext.setAttribute(DriverServlet.SESSIONS_KEY, new DefaultDriverSessions());
        webdriverContext.setContextPath("/wd");
        ServletHandler handler = new ServletHandler();
        handler.addServlet("WebDriver remote server", "/hub/*", DriverServlet.class.getName());
        webdriverContext.addHandler(handler);
        this.LOGGER.info((Object)String.format("RemoteWebDriver instances should connect to: http://%s:%d/wd/hub", networkUtils.getPrivateLocalAddress(), this.getPort()));
        return webdriverContext;
    }

    private void addStaticContentHandler(boolean slowResources, RemoteControlConfiguration configuration, HttpContext context) {
        StaticContentHandler.setSlowResources(slowResources);
        this.staticContentHandler = new StaticContentHandler(configuration.getDebugURL(), configuration.getProxyInjectionModeArg());
        String overrideJavascriptDir = System.getProperty("selenium.javascript.dir");
        if (overrideJavascriptDir != null) {
            this.staticContentHandler.addStaticContent(new FsResourceLocator(new File(overrideJavascriptDir)));
        }
        this.staticContentHandler.addStaticContent(new ClasspathResourceLocator());
        context.addHandler(this.staticContentHandler);
    }

    private void addSecurityHandler(HttpContext context) {
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setName("BASIC");
        constraint.addRole("user");
        constraint.setAuthenticate(true);
        context.addSecurityConstraint("/tests/html/basicAuth/*", constraint);
        HashUserRealm realm = new HashUserRealm("MyRealm");
        realm.put("alice", "foo");
        realm.addUserToRole("alice", "user");
        context.setRealm(realm);
        SecurityHandler sh = new SecurityHandler();
        context.addHandler(sh);
    }

    protected HttpContext createRootContextWithProxyHandler(RemoteControlConfiguration configuration) {
        HttpContext root = new HttpContext();
        root.setContextPath("/");
        this.proxyHandler = this.makeProxyHandler(configuration);
        this.proxyHandler.setShutdownLock(this.shutdownLock);
        root.addHandler(this.proxyHandler);
        return root;
    }

    public void generateSSLCertsForLoggingHosts() {
        this.proxyHandler.generateSSLCertsForLoggingHosts(this.server);
    }

    protected ProxyHandler makeProxyHandler(RemoteControlConfiguration configuration) {
        ProxyHandler proxyHandler = customProxyHandler == null ? new ProxyHandler(configuration.trustAllSSLCertificates(), configuration.getDontInjectRegex(), configuration.getDebugURL(), configuration.getProxyInjectionModeArg(), false) : customProxyHandler;
        return proxyHandler;
    }

    private static boolean slowResourceProperty() {
        return "true".equals(System.getProperty("slowResources"));
    }

    public void addNewStaticContent(File directory) {
        this.staticContentHandler.addStaticContent(new FsResourceLocator(directory));
    }

    public void handleHTMLRunnerResults(HTMLResultsListener listener) {
        this.postResultsHandler.addListener(listener);
    }

    public void start() throws Exception {
        System.setProperty("org.openqa.jetty.http.HttpRequest.maxFormContentSize", "0");
        try {
            this.server.start();
        }
        catch (MultiException e) {
            if (e.getExceptions().size() == 1 && e.getException(0) instanceof BindException) {
                throw new BindException("Selenium is already running on port " + this.getPort() + ". Or some other service is.");
            }
            throw e;
        }
        this.shutDownHook = new Thread(new ShutDownHook(this));
        this.shutDownHook.setName("SeleniumServerShutDownHook");
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    public static void setCustomProxyHandler(ProxyHandler customProxyHandler) {
        SeleniumServer.customProxyHandler = customProxyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        int numTries = 0;
        Exception shutDownException = null;
        try {
            if (this.shutDownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutDownHook);
            }
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        while (numTries <= 8) {
            ++numTries;
            try {
                Object e = this.shutdownLock;
                synchronized (e) {
                    this.server.stop();
                    break;
                }
            }
            catch (Exception ex) {
                this.LOGGER.error((Object)ex);
                shutDownException = ex;
            }
        }
        this.driver.stopAllBrowsers();
        if (numTries > 8 && null != shutDownException) {
            throw new RuntimeException(shutDownException);
        }
    }

    public RemoteControlConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getPort() {
        return this.configuration.getPort();
    }

    public Server getServer() {
        return this.server;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        return this.staticContentHandler.getResource(path).getInputStream();
    }

    public void registerBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.driver.registerBrowserSession(sessionInfo);
    }

    public void deregisterBrowserSession(BrowserSessionFactory.BrowserSessionInfo sessionInfo) {
        this.driver.deregisterBrowserSession(sessionInfo);
    }

    public int getJettyThreads() {
        return this.jettyThreads;
    }

    protected void runHtmlSuite() {
        try {
            String result;
            String suiteFilePath = this.getRequiredSystemProperty("htmlSuite.suiteFilePath");
            File suiteFile = new File(suiteFilePath);
            if (!suiteFile.exists()) {
                RemoteControlLauncher.usage("Can't find HTML Suite file:" + suiteFile.getAbsolutePath());
                System.exit(1);
            }
            this.addNewStaticContent(suiteFile.getParentFile());
            String startURL = this.getRequiredSystemProperty("htmlSuite.startURL");
            HTMLLauncher launcher = new HTMLLauncher(this);
            String resultFilePath = this.getRequiredSystemProperty("htmlSuite.resultFilePath");
            File resultFile = new File(resultFilePath);
            resultFile.createNewFile();
            if (!resultFile.canWrite()) {
                RemoteControlLauncher.usage("can't write to result file " + resultFilePath);
                System.exit(1);
            }
            if (!"PASSED".equals(result = launcher.runHTMLSuite(this.getRequiredSystemProperty("htmlSuite.browserString"), startURL, suiteFile, resultFile, this.configuration.getTimeoutInSeconds(), !this.configuration.isSingleWindow()))) {
                System.err.println("Tests failed, see result file for details: " + resultFile.getAbsolutePath());
                System.exit(1);
            } else {
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("HTML suite exception seen:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void readUserCommands() throws IOException {
        String userInput;
        AsyncExecute.sleepTight((long)500L);
        System.out.println("Entering interactive mode... type Selenium commands here (e.g: cmd=open&1=http://www.yahoo.com)");
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        final String[] lastSessionId = new String[]{""};
        while ((userInput = stdIn.readLine()) != null) {
            boolean newBrowserSession;
            if ("exit".equals(userInput = userInput.trim()) || "quit".equals(userInput)) {
                System.out.println("Stopping...");
                this.stop();
                System.exit(0);
            }
            if ("".equals(userInput)) continue;
            if (!userInput.startsWith("cmd=") && !userInput.startsWith("commandResult=")) {
                System.err.println("ERROR -  Invalid command: \"" + userInput + "\"");
                continue;
            }
            boolean bl = newBrowserSession = userInput.indexOf("getNewBrowserSession") != -1;
            if (userInput.indexOf("sessionId") == -1 && !newBrowserSession) {
                userInput = userInput + "&sessionId=" + lastSessionId[0];
            }
            final URL url = new URL("http://localhost:" + this.configuration.getPort() + "/selenium-server/driver?" + userInput);
            Thread t = new Thread(new Runnable(){

                public void run() {
                    block4: {
                        try {
                            int length;
                            SeleniumServer.this.LOGGER.info((Object)("---> Requesting " + url.toString()));
                            URLConnection conn = url.openConnection();
                            conn.connect();
                            InputStream is = conn.getInputStream();
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            byte[] buffer = new byte[2048];
                            while ((length = is.read(buffer)) != -1) {
                                out.write(buffer, 0, length);
                            }
                            is.close();
                            String output = out.toString();
                            if (newBrowserSession && output.startsWith("OK,")) {
                                lastSessionId[0] = output.substring(3);
                            }
                        }
                        catch (IOException e) {
                            System.err.println(e.getMessage());
                            if (!SeleniumServer.this.debugMode) break block4;
                            e.printStackTrace();
                        }
                    }
                }
            });
            t.start();
        }
    }

    protected static void checkArgsSanity(RemoteControlConfiguration configuration) throws Exception {
        if (configuration.isInteractive()) {
            if (configuration.isHTMLSuite()) {
                System.err.println("You can't use -interactive and -htmlSuite on the same line!");
                System.exit(1);
            }
            if (configuration.isSelfTest()) {
                System.err.println("You can't use -interactive and -selfTest on the same line!");
                System.exit(1);
            }
        } else if (configuration.isSelfTest() && configuration.isHTMLSuite()) {
            System.err.println("You can't use -selfTest and -htmlSuite on the same line!");
            System.exit(1);
        }
        if (!configuration.getProxyInjectionModeArg() && (InjectionHelper.userContentTransformationsExist() || InjectionHelper.userJsInjectionsExist())) {
            RemoteControlLauncher.usage("-userJsInjection and -userContentTransformation are only valid in combination with -proxyInjectionMode");
            System.exit(1);
        }
    }

    private void sanitizeProxyConfiguration() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (Integer.toString(this.getPort()).equals(proxyPort)) {
            this.LOGGER.debug((Object)("http.proxyPort is the same as the Selenium Server port " + this.getPort()));
            this.LOGGER.debug((Object)("http.proxyHost=" + proxyHost));
            if ("localhost".equals(proxyHost) || "127.0.0.1".equals(proxyHost)) {
                this.LOGGER.info((Object)"Forcing http.proxyHost to '' to avoid infinite loop");
                System.setProperty("http.proxyHost", "");
            }
        }
    }

    private void logStartupInfo() throws IOException {
        this.LOGGER.info((Object)("Java: " + System.getProperty("java.vm.vendor") + ' ' + System.getProperty("java.vm.version")));
        this.LOGGER.info((Object)("OS: " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch")));
        this.logVersionNumber();
        if (this.debugMode) {
            this.LOGGER.info((Object)"Selenium server running in debug mode.");
        }
        if (this.configuration.getProxyInjectionModeArg()) {
            this.LOGGER.info((Object)"The selenium server will execute in proxyInjection mode.");
        }
        if (this.configuration.reuseBrowserSessions()) {
            this.LOGGER.info((Object)"Will recycle browser sessions when possible.");
        }
        if (null != this.configuration.getForcedBrowserMode()) {
            this.LOGGER.info((Object)("\"" + this.configuration.getForcedBrowserMode() + "\" will be used as the browser " + "mode for all sessions, no matter what is passed to getNewBrowserSession."));
        }
    }

    private String getRequiredSystemProperty(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            RemoteControlLauncher.usage("expected property " + name + " to be defined");
            System.exit(1);
        }
        return value;
    }

    static {
        DEFAULT_JETTY_THREADS = 512;
    }

    private class ShutDownHook
    implements Runnable {
        SeleniumServer selenium;

        ShutDownHook(SeleniumServer selenium) {
            this.selenium = selenium;
        }

        public void run() {
            SeleniumServer.this.LOGGER.info((Object)"Shutting down...");
            this.selenium.stop();
        }
    }
}

