/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.log.AntJettyLoggerBuildListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsProxyManager {
    static Log log = LogFactory.getLog(WindowsProxyManager.class);
    protected static final String REG_KEY_BACKUP_READY = "BackupReady";
    protected static final String COOKIE_SUFFIX = ".txt";
    protected static final File HIDDEN_COOKIE_DIR = new File(System.getenv("USERPROFILE") + File.separator + "CookiesHiddenBySeleniumRC");
    protected static String REG_KEY_BASE = "HKEY_CURRENT_USER";
    private static final Pattern HUDSUCKR_LINE = Pattern.compile("^([^=]+)=(.*)$");
    private HudsuckrSettings oldSettings;
    private boolean customPACappropriate;
    private File customProxyPACDir;
    private int port;
    private int portDriversShouldContact;
    private boolean changeMaxConnections;
    private static final Preferences prefs = Preferences.userNodeForPackage(WindowsProxyManager.class);

    public WindowsProxyManager(boolean customPACappropriate, String sessionId, int port, int portDriversShouldContact) {
        this.portDriversShouldContact = portDriversShouldContact;
        this.customPACappropriate = customPACappropriate;
        this.port = port;
        this.customProxyPACDir = LauncherUtils.createCustomProfileDir(sessionId);
        if (this.customProxyPACDir.exists()) {
            LauncherUtils.recursivelyDeleteDir(this.customProxyPACDir);
        }
        this.customProxyPACDir.mkdir();
        this.init();
    }

    public void setChangeMaxConnections(boolean changeMaxConnections) {
        this.changeMaxConnections = changeMaxConnections;
    }

    public boolean getChangeMaxConnections() {
        return this.changeMaxConnections;
    }

    public File getCustomProxyPACDir() {
        return this.customProxyPACDir;
    }

    protected void init() {
        this.handleEvilPopupMgrBackup();
    }

    protected void handleEvilPopupMgrBackup() {
        if (RegKey.POPUP_MGR.type != null) {
            return;
        }
        RegKey.POPUP_MGR.type = WindowsUtils.discoverRegistryKeyType(RegKey.POPUP_MGR.key);
        Class<?> backupPopupMgrType = this.discoverPrefKeyType(RegKey.POPUP_MGR.name());
        if (RegKey.POPUP_MGR.type == null) {
            if (backupPopupMgrType == null) {
                RegKey.POPUP_MGR.type = Boolean.TYPE;
                return;
            }
            RegKey.POPUP_MGR.type = backupPopupMgrType;
            return;
        }
        if (RegKey.POPUP_MGR.type.equals(backupPopupMgrType)) {
            return;
        }
        if (backupPopupMgrType != null) {
            WindowsUtils.deleteRegistryValue(RegKey.POPUP_MGR.key);
        }
        if (!this.backupIsReady()) {
            return;
        }
        String value = "no";
        if (RegKey.POPUP_MGR.type.equals(Boolean.TYPE)) {
            value = "false";
        }
        prefs.put(RegKey.POPUP_MGR.name(), value);
    }

    private static boolean prefNodeExists(String key) {
        return null != prefs.get(key, null);
    }

    private Class<?> discoverPrefKeyType(String key) {
        String data = prefs.get(key, null);
        if (data == null) {
            return null;
        }
        if ("true".equals(data) || "false".equals(data)) {
            return Boolean.TYPE;
        }
        try {
            Integer.parseInt(data);
            return Integer.TYPE;
        }
        catch (NumberFormatException e) {
            return String.class;
        }
    }

    public static void setBaseRegKey(String base) {
        REG_KEY_BASE = base;
    }

    protected void changeRegistrySettings(BrowserConfigurationOptions options) throws IOException {
        HudsuckrSettings settings;
        log.info((Object)"Modifying registry settings...");
        if (this.oldSettings == null) {
            this.backupHudsuckrSettings();
        }
        if (!this.customPACappropriate) {
            String proxyServer = "127.0.0.1:" + this.portDriversShouldContact;
            settings = new HudsuckrSettings(this.oldSettings.connection, true, true, false, false, proxyServer, "(null)", "(null)");
        } else {
            File proxyPAC = LauncherUtils.makeProxyPAC(this.customProxyPACDir, this.port, options);
            String newURL = "file://" + proxyPAC.getAbsolutePath().replace('\\', '/');
            settings = new HudsuckrSettings(this.oldSettings.connection, true, false, true, false, "(null)", "(null)", newURL);
        }
        this.runHudsuckr(settings.toStringArray());
        try {
            WindowsUtils.writeBooleanRegistryValue(RegKey.AUTOPROXY_RESULT_CACHE.key, false);
        }
        catch (WindowsUtils.WindowsRegistryException ex) {
            log.debug((Object)"Couldn't modify autoproxy result cache; this often fails on Vista, but it's merely a nice-to-have", (Throwable)ex);
        }
        try {
            WindowsUtils.writeStringRegistryValue(RegKey.MIME_EXCLUSION_LIST_FOR_CACHE.key, "multipart/mixed multipart/x-mixed-replace multipart/x-byteranges text/html");
        }
        catch (WindowsUtils.WindowsRegistryException ex) {
            log.debug((Object)"Couldn't disable caching of html; this often fails on Vista, but it's merely a nice-to-have", (Throwable)ex);
        }
        WindowsUtils.writeBooleanRegistryValue(RegKey.USERNAME_PASSWORD_DISABLE.key, false);
        if (WindowsUtils.doesRegistryValueExist(RegKey.POPUP_MGR.key)) {
            WindowsUtils.deleteRegistryValue(RegKey.POPUP_MGR.key);
        }
        if (RegKey.POPUP_MGR.type.equals(String.class)) {
            WindowsUtils.writeStringRegistryValue(RegKey.POPUP_MGR.key, "no");
        } else {
            WindowsUtils.writeBooleanRegistryValue(RegKey.POPUP_MGR.key, false);
        }
        WindowsUtils.writeBooleanRegistryValue(RegKey.WARN_ON_FORM_SUBMIT.key, false);
        if (this.changeMaxConnections) {
            WindowsUtils.writeIntRegistryValue(RegKey.MAX_CONNECTIONS_PER_1_0_SVR.key, 256);
            WindowsUtils.writeIntRegistryValue(RegKey.MAX_CONNECTIONS_PER_1_1_SVR.key, 256);
        }
        if (options.isEnsuringCleanSession()) {
            WindowsProxyManager.hidePreexistingCookies();
            WindowsProxyManager.deleteTemporaryInternetFiles();
        }
    }

    private static void deleteTemporaryInternetFiles() {
        String cachePath = WindowsUtils.readStringRegistryValue(REG_KEY_BASE + "\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Cache");
        File globalCacheDir = new File(cachePath);
        File iexploreCacheDir = new File(globalCacheDir, "Content.IE5");
        if (iexploreCacheDir.exists()) {
            try {
                LauncherUtils.recursivelyDeleteDir(iexploreCacheDir);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
        }
    }

    public void backupRegistrySettings() {
        if (this.backupIsReady()) {
            return;
        }
        log.info((Object)"Backing up registry settings...");
        for (RegKey key : RegKey.values()) {
            key.backup();
        }
        this.backupHudsuckrSettings();
        this.backupReady(true);
    }

    public void restoreRegistrySettings(boolean ensureCleanSession) {
        if (ensureCleanSession) {
            WindowsProxyManager.restorePreexistingCookies();
        }
        if (!this.backupIsReady()) {
            return;
        }
        log.info((Object)"Restoring registry settings (won't affect running browsers)...");
        for (RegKey key : RegKey.values()) {
            key.restore();
        }
        this.restoreHudsuckrSettings();
        this.backupReady(false);
    }

    private static void hidePreexistingCookies() {
        boolean done = false;
        File cookieDir = WindowsProxyManager.getCookieDir();
        done = WindowsProxyManager.hideCookies(cookieDir, COOKIE_SUFFIX, HIDDEN_COOKIE_DIR);
        if (!done) {
            log.warn((Object)"Could not hide pre-existing cookies using either theWinXP directory structure or the Vista directory structure");
        }
    }

    protected static boolean hideCookies(File cookieDir, String cookieSuffix, File hiddenCookieDir) {
        boolean result = false;
        LauncherUtils.recursivelyDeleteDir(hiddenCookieDir);
        if (cookieDir.exists()) {
            log.info((Object)("Copying cookies from " + cookieDir.getAbsolutePath() + " to " + hiddenCookieDir.getAbsolutePath()));
            LauncherUtils.copyDirectory(cookieDir, cookieSuffix, hiddenCookieDir);
            log.info((Object)"Deleting original cookies...");
            WindowsProxyManager.deleteFlatDirContents(cookieDir, cookieSuffix);
            result = true;
        }
        return result;
    }

    private static File getCookieDir() {
        String cookiePath = WindowsUtils.readStringRegistryValue(REG_KEY_BASE + "\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Cookies");
        File cookieDir = new File(cookiePath);
        return cookieDir;
    }

    private static void restorePreexistingCookies() {
        boolean done = false;
        File cookieDir = WindowsProxyManager.getCookieDir();
        done = WindowsProxyManager.restoreCookies(cookieDir, COOKIE_SUFFIX, HIDDEN_COOKIE_DIR);
        if (!done) {
            log.warn((Object)"Could not restore pre-existing cookies, using either theWinXp directory structure or the Vista directory structure");
        }
    }

    protected static boolean restoreCookies(File cookieDir, String cookieSuffix, File hiddenCookieDir) {
        boolean result = false;
        if (cookieDir.exists()) {
            log.info((Object)("Deleting cookies created during session from " + cookieDir.getAbsolutePath()));
            WindowsProxyManager.deleteFlatDirContents(cookieDir, cookieSuffix);
        }
        if (hiddenCookieDir.exists()) {
            log.info((Object)("Copying cookies from " + hiddenCookieDir.getAbsolutePath() + " to " + cookieDir.getAbsolutePath()));
            LauncherUtils.copyDirectory(hiddenCookieDir, cookieDir);
            LauncherUtils.recursivelyDeleteDir(hiddenCookieDir);
            result = true;
        }
        return result;
    }

    protected static void deleteFlatDirContents(File dir, String suffix) {
        if (dir.exists()) {
            log.info((Object)("looking for files ending with: " + suffix));
            File[] list = dir.listFiles(new SuffixFilter(suffix));
            if (null != list) {
                for (File file : list) {
                    boolean success = file.delete();
                    if (success) continue;
                    log.warn((Object)("Could not delete file " + file.getAbsolutePath()));
                }
            } else {
                log.info((Object)"...no matching files");
            }
        }
    }

    private boolean backupIsReady() {
        if (!WindowsProxyManager.prefNodeExists(REG_KEY_BACKUP_READY)) {
            return false;
        }
        return prefs.getBoolean(REG_KEY_BACKUP_READY, false);
    }

    private void backupReady(boolean backupReady) {
        prefs.putBoolean(REG_KEY_BACKUP_READY, backupReady);
    }

    private File extractHudsuckr() {
        File hudsuckr = new File(this.customProxyPACDir, "hudsuckr.exe");
        if (hudsuckr.exists()) {
            return hudsuckr;
        }
        try {
            ResourceExtractor.extractResourcePath(WindowsProxyManager.class, "/hudsuckr/hudsuckr.exe", hudsuckr);
        }
        catch (IOException e) {
            throw new RuntimeException("Bug extracting hudsuckr", e);
        }
        return hudsuckr;
    }

    private String runHudsuckr(String ... args) {
        Project p = new Project();
        p.addBuildListener((BuildListener)new AntJettyLoggerBuildListener(log));
        ExecTask exec = new ExecTask();
        exec.setProject(p);
        exec.setTaskType("hudsuckr");
        exec.setExecutable(this.extractHudsuckr().getAbsolutePath());
        exec.setFailonerror(false);
        exec.setResultProperty("result");
        exec.setOutputproperty("output");
        for (String arg : args) {
            exec.createArg().setValue(String.valueOf(arg));
        }
        exec.execute();
        String output = p.getProperty("output");
        String result = p.getProperty("result");
        if (!"0".equals(result)) {
            throw new RuntimeException("exec return code " + result + ": " + output);
        }
        return output;
    }

    private HudsuckrSettings parseHudsuckrSettings(String hudsuckrOutput) {
        Map<String, String> settings = LauncherUtils.parseDictionary(hudsuckrOutput, HUDSUCKR_LINE);
        for (HudsuckrKey key : HudsuckrKey.values()) {
            if (settings.containsKey(key.name())) continue;
            throw new RuntimeException("Bug! Hudsuckr settings didn't include " + (Object)((Object)key) + ": " + hudsuckrOutput);
        }
        String connection = settings.get(HudsuckrKey.ACTIVE_CONNECTION.name());
        boolean direct = "true".equals(settings.get(HudsuckrKey.PROXY_TYPE_DIRECT.name()));
        boolean proxy = "true".equals(settings.get(HudsuckrKey.PROXY_TYPE_PROXY.name()));
        boolean pac = "true".equals(settings.get(HudsuckrKey.PROXY_TYPE_AUTO_PROXY_URL.name()));
        boolean wpad = "true".equals(settings.get(HudsuckrKey.PROXY_TYPE_AUTO_DETECT.name()));
        String server = settings.get(HudsuckrKey.INTERNET_PER_CONN_PROXY_SERVER.name());
        String bypass = settings.get(HudsuckrKey.INTERNET_PER_CONN_PROXY_BYPASS.name());
        String pacUrl = settings.get(HudsuckrKey.INTERNET_PER_CONN_AUTOCONFIG_URL.name());
        return new HudsuckrSettings(connection, direct, proxy, pac, wpad, server, bypass, pacUrl);
    }

    private void backupHudsuckrSettings() {
        HudsuckrSettings settings;
        String output = this.runHudsuckr(new String[0]);
        this.oldSettings = settings = this.parseHudsuckrSettings(output);
        prefs.put(HudsuckrKey.ACTIVE_CONNECTION.name(), settings.connection);
        prefs.putBoolean(HudsuckrKey.PROXY_TYPE_DIRECT.name(), settings.direct);
        prefs.putBoolean(HudsuckrKey.PROXY_TYPE_PROXY.name(), settings.proxy);
        prefs.putBoolean(HudsuckrKey.PROXY_TYPE_AUTO_PROXY_URL.name(), settings.pac);
        prefs.putBoolean(HudsuckrKey.PROXY_TYPE_AUTO_DETECT.name(), settings.wpad);
        prefs.put(HudsuckrKey.INTERNET_PER_CONN_PROXY_SERVER.name(), settings.server);
        prefs.put(HudsuckrKey.INTERNET_PER_CONN_PROXY_BYPASS.name(), settings.bypass);
        prefs.put(HudsuckrKey.INTERNET_PER_CONN_AUTOCONFIG_URL.name(), settings.pacUrl);
    }

    private void restoreHudsuckrSettings() {
        for (HudsuckrKey key : HudsuckrKey.values()) {
            if (WindowsProxyManager.prefNodeExists(key.name())) continue;
            throw new RuntimeException("Bug!  Prefs don't contain " + (Object)((Object)key));
        }
        String connection = prefs.get(HudsuckrKey.ACTIVE_CONNECTION.name(), null);
        boolean direct = prefs.getBoolean(HudsuckrKey.PROXY_TYPE_DIRECT.name(), false);
        boolean proxy = prefs.getBoolean(HudsuckrKey.PROXY_TYPE_PROXY.name(), false);
        boolean pac = prefs.getBoolean(HudsuckrKey.PROXY_TYPE_AUTO_PROXY_URL.name(), false);
        boolean wpad = prefs.getBoolean(HudsuckrKey.PROXY_TYPE_AUTO_DETECT.name(), false);
        String server = prefs.get(HudsuckrKey.INTERNET_PER_CONN_PROXY_SERVER.name(), null);
        String bypass = prefs.get(HudsuckrKey.INTERNET_PER_CONN_PROXY_BYPASS.name(), null);
        String pacUrl = prefs.get(HudsuckrKey.INTERNET_PER_CONN_AUTOCONFIG_URL.name(), null);
        HudsuckrSettings settings = new HudsuckrSettings(connection, direct, proxy, pac, wpad, server, bypass, pacUrl);
        this.runHudsuckr(settings.toStringArray());
    }

    private static class SuffixFilter
    implements FileFilter {
        private final String suffix;

        public SuffixFilter(String suffix) {
            this.suffix = suffix;
        }

        public boolean accept(File pathname) {
            boolean result = false;
            if (null == this.suffix) {
                result = true;
            } else if (pathname.getName().endsWith(this.suffix)) {
                result = true;
            }
            return result;
        }
    }

    private static class HudsuckrSettings {
        final String connection;
        final String server;
        final String bypass;
        final String pacUrl;
        final boolean direct;
        final boolean proxy;
        final boolean pac;
        final boolean wpad;

        public HudsuckrSettings(String connection, boolean direct, boolean proxy, boolean pac, boolean wpad, String server, String bypass, String pacUrl) {
            this.connection = connection;
            this.server = server;
            this.bypass = bypass;
            this.pacUrl = pacUrl;
            this.direct = direct;
            this.proxy = proxy;
            this.pac = pac;
            this.wpad = wpad;
        }

        public String[] toStringArray() {
            String[] result = new String[]{this.connection, Boolean.toString(this.direct), Boolean.toString(this.proxy), Boolean.toString(this.pac), Boolean.toString(this.wpad), this.server, this.bypass, this.pacUrl};
            return result;
        }

        public String toString() {
            return Arrays.toString(this.toStringArray());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HudsuckrKey {
        ACTIVE_CONNECTION,
        PROXY_TYPE_DIRECT,
        PROXY_TYPE_PROXY,
        PROXY_TYPE_AUTO_PROXY_URL,
        PROXY_TYPE_AUTO_DETECT,
        INTERNET_PER_CONN_PROXY_SERVER,
        INTERNET_PER_CONN_PROXY_BYPASS,
        INTERNET_PER_CONN_AUTOCONFIG_URL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RegKey {
        POPUP_MGR(REG_KEY_BASE + "\\Software\\Microsoft\\Internet Explorer\\New Windows\\PopupMgr", null),
        USERNAME_PASSWORD_DISABLE(REG_KEY_BASE + "\\Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_HTTP_USERNAME_PASSWORD_DISABLE\\iexplore.exe", Boolean.TYPE),
        MAX_CONNECTIONS_PER_1_0_SVR(REG_KEY_BASE + "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\MaxConnectionsPer1_0Server", Integer.TYPE),
        MAX_CONNECTIONS_PER_1_1_SVR(REG_KEY_BASE + "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\MaxConnectionsPerServer", Integer.TYPE),
        AUTOPROXY_RESULT_CACHE(REG_KEY_BASE + "\\Software\\Policies\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\EnableAutoproxyResultCache", Boolean.TYPE),
        MIME_EXCLUSION_LIST_FOR_CACHE(REG_KEY_BASE + "\\Software\\Policies\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\MimeExclusionListForCache", String.class),
        WARN_ON_FORM_SUBMIT(REG_KEY_BASE + "\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\\Zones\\3\\1601", Boolean.TYPE);

        String key;
        Class<?> type;

        private RegKey(String key, Class<?> type) {
            this.key = key;
            this.type = type;
        }

        private boolean backupExists() {
            return WindowsProxyManager.prefNodeExists(this.name());
        }

        private boolean originalExists() {
            return WindowsUtils.doesRegistryValueExist(this.key);
        }

        private void backup() {
            if (this.originalExists()) {
                if (this.type.equals(String.class)) {
                    String data = WindowsUtils.readStringRegistryValue(this.key);
                    prefs.put(this.name(), data);
                    return;
                }
                if (this.type.equals(Boolean.TYPE)) {
                    boolean data = WindowsUtils.readBooleanRegistryValue(this.key);
                    prefs.putBoolean(this.name(), data);
                    return;
                }
                if (this.type.equals(Integer.TYPE)) {
                    int data = WindowsUtils.readIntRegistryValue(this.key);
                    prefs.putInt(this.name(), data);
                    return;
                }
                throw new RuntimeException("Bad type: " + this.type.getName());
            }
            prefs.remove(this.name());
        }

        private void restore() {
            if (this.backupExists()) {
                if (this.type.equals(String.class)) {
                    String data = prefs.get(this.name(), null);
                    WindowsUtils.writeStringRegistryValue(this.key, data);
                    return;
                }
                if (this.type.equals(Boolean.TYPE)) {
                    boolean data = prefs.getBoolean(this.name(), false);
                    WindowsUtils.writeBooleanRegistryValue(this.key, data);
                    return;
                }
                if (this.type.equals(Integer.TYPE)) {
                    int data = prefs.getInt(this.name(), 0);
                    WindowsUtils.writeIntRegistryValue(this.key, data);
                    return;
                }
                throw new RuntimeException("Bad type: " + this.type.getName());
            }
            if (WindowsUtils.doesRegistryValueExist(this.key)) {
                WindowsUtils.deleteRegistryValue(this.key);
            }
        }
    }
}

