/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.GridException;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.listeners.TestSessionListener;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.Selenium1RequestHandler;
import org.openqa.grid.web.servlet.handler.WebDriverRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestHandler
implements Comparable<RequestHandler> {
    private Registry registry;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String body = null;
    private boolean bodyHasBeenRead = false;
    private Map<String, Object> desiredCapabilities = null;
    private RequestType requestType = null;
    private TestSession session = null;
    private long created;
    private boolean showWarning = true;
    private final Lock lock = new ReentrantLock();
    private final Condition sessionHasBeenAssigned = this.lock.newCondition();
    private static final Logger log = Logger.getLogger(RequestHandler.class.getName());

    public static RequestHandler createHandler(HttpServletRequest request, HttpServletResponse response, Registry registry) {
        if (RequestHandler.isSeleniumProtocol(request)) {
            return new Selenium1RequestHandler(request, response, registry);
        }
        return new WebDriverRequestHandler(request, response, registry);
    }

    protected RequestHandler(HttpServletRequest request, HttpServletResponse response, Registry registry) {
        this.request = request;
        this.response = response;
        this.registry = registry;
        this.created = System.currentTimeMillis();
    }

    public abstract RequestType extractRequestType();

    public abstract String extractSession();

    public abstract Map<String, Object> extractDesiredCapability();

    public abstract String forwardNewSessionRequest(TestSession var1);

    protected void forwardRequest(TestSession session, RequestHandler handler) throws IOException {
        if (this.bodyHasBeenRead) {
            session.forward(this.request, this.response, this.getRequestBody(), false);
        } else {
            session.forward(this.request, this.response);
        }
    }

    public void process() {
        switch (this.getRequestType()) {
            case START_SESSION: {
                this.handleNewSession();
                break;
            }
            case REGULAR: 
            case STOP_SESSION: {
                this.session = this.getSession();
                if (this.session == null) {
                    throw new GridException("Session not available - " + this.registry.getActiveSessions());
                }
                try {
                    this.forwardRequest(this.session, this);
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, "cannot forward the request " + t.getMessage(), t);
                    this.session.terminate();
                    throw new GridException("cannot forward the request " + t.getMessage(), t);
                }
                if (this.getRequestType() != RequestType.STOP_SESSION) break;
                this.session.terminate();
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNewSession() {
        String externalKey;
        try {
            this.lock.lock();
            this.registry.addNewSessionRequest(this);
            if (this.registry.getNewSessionWaitTimeout() != -1) {
                long startTime = System.currentTimeMillis();
                this.sessionHasBeenAssigned.await(this.registry.getNewSessionWaitTimeout(), TimeUnit.MILLISECONDS);
                long endTime = System.currentTimeMillis();
                if (this.session == null && endTime - startTime >= (long)this.registry.getNewSessionWaitTimeout()) {
                    throw new RuntimeException("Request timed out waiting for a node to become available.");
                }
            } else {
                this.sessionHasBeenAssigned.await();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        if (this.session == null) {
            throw new RuntimeException("implementation error or you closed the grid while some tests were still queued on it.");
        }
        RemoteProxy p = this.session.getSlot().getProxy();
        if (p instanceof TestSessionListener) {
            if (this.showWarning && p.getMaxNumberOfConcurrentTestSessions() != 1) {
                this.showWarning = false;
                log.warning("WARNING : using a beforeSession on a proxy that can support multiple tests is risky.");
            }
            try {
                ((TestSessionListener)((Object)p)).beforeSession(this.session);
            }
            catch (Throwable t) {
                log.severe("Error running the beforeSessionListener : " + t.getMessage());
                t.printStackTrace();
                this.session.terminate();
            }
        }
        if ((externalKey = this.forwardNewSessionRequest(this.session)) == null) {
            this.session.terminate();
            throw new GridException("Error getting a new session from the remote." + this.registry.getAllProxies());
        }
        this.session.setExternalKey(externalKey);
    }

    private static boolean isSeleniumProtocol(HttpServletRequest request) {
        return "/selenium-server/driver".equals(request.getServletPath());
    }

    protected String getRequestBody() {
        if (!this.bodyHasBeenRead) {
            this.bodyHasBeenRead = true;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                ServletInputStream is = this.request.getInputStream();
                if (is == null) {
                    return null;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                is.close();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.body = sb.toString();
        }
        return this.body;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Map<String, Object> getDesiredCapabilities() {
        if (this.desiredCapabilities == null) {
            this.desiredCapabilities = this.extractDesiredCapability();
        }
        return this.desiredCapabilities;
    }

    protected void setDesiredCapabilities(Map<String, Object> desiredCapabilities) {
        this.desiredCapabilities = desiredCapabilities;
    }

    @Override
    public int compareTo(RequestHandler o) {
        Prioritizer prioritizer = this.registry.getPrioritizer();
        if (prioritizer != null) {
            return prioritizer.compareTo(this.getDesiredCapabilities(), o.getDesiredCapabilities());
        }
        return 0;
    }

    protected RequestType getRequestType() {
        if (this.requestType == null) {
            this.requestType = this.extractRequestType();
        }
        return this.requestType;
    }

    protected void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    protected void setSession(TestSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindSession(TestSession session) {
        try {
            this.lock.lock();
            this.session = session;
            this.sessionHasBeenAssigned.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected TestSession getSession() {
        if (this.session == null) {
            String externalKey = this.extractSession();
            this.session = this.registry.getSession(externalKey);
        }
        return this.session;
    }

    public String getServerSession() {
        if (this.session == null) {
            return null;
        }
        return this.session.getExternalKey();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("session :" + this.session + " , ");
        b.append("cap : " + this.getDesiredCapabilities());
        b.append("\n");
        return b.toString();
    }

    public String debug() {
        StringBuilder b = new StringBuilder();
        b.append("\nmethod: " + this.request.getMethod());
        b.append("\npathInfo: " + this.request.getPathInfo());
        b.append("\nuri: " + this.request.getRequestURI());
        b.append("\ncontent :" + this.getRequestBody());
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.session == null ? 0 : this.session.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestHandler other = (RequestHandler)obj;
        return !(this.session == null ? other.session != null : !this.session.equals(other.session));
    }

    public long getCreated() {
        return this.created;
    }

    public Registry getRegistry() {
        return this.registry;
    }
}

