/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.web.servlet.ConsoleServlet;

public class DisplayHelpServlet
extends HttpServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    private static final Logger log = Logger.getLogger(ConsoleServlet.class.getName());
    private static String coreVersion;
    private static String coreRevision;

    public DisplayHelpServlet() {
        this.getVersion();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<head>");
        builder.append("<title>Selenium Grid2.0 help</title>");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("You are using grid " + coreRevision + coreRevision);
        builder.append("Find help on the official selenium wiki : <a href='http://code.google.com/p/selenium/wiki/Grid2' >more help here</a>");
        builder.append("</body>");
        builder.append("</html>");
        ByteArrayInputStream in = new ByteArrayInputStream(builder.toString().getBytes("UTF-8"));
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((InputStream)in).close();
            response.getOutputStream().close();
            throw throwable;
        }
        ((InputStream)in).close();
        response.getOutputStream().close();
    }

    private void getVersion() {
        Properties p = new Properties();
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("VERSION.txt");
        if (stream == null) {
            log.severe("Couldn't determine version number");
            return;
        }
        try {
            p.load(stream);
        }
        catch (IOException e) {
            log.severe("Cannot load version from VERSION.txt" + e.getMessage());
        }
        coreVersion = p.getProperty("selenium.core.version");
        coreRevision = p.getProperty("selenium.core.revision");
        if (coreVersion == null) {
            log.severe("Cannot load selenium.core.version from VERSION.txt");
        }
    }
}

