/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import org.openqa.selenium.remote.SessionId;

public class SessionLogsToFileRepository {
    private Map<SessionId, LogFile> sessionToLogFileMap = new HashMap<SessionId, LogFile>();

    public void createLogFileAndAddToMap(SessionId sessionId) throws IOException {
        File rcLogFile = File.createTempFile(sessionId.toString(), ".rclog");
        rcLogFile.deleteOnExit();
        LogFile logFile = new LogFile(rcLogFile.getAbsolutePath());
        this.sessionToLogFileMap.put(sessionId, logFile);
    }

    public synchronized void flushRecordsToLogFile(SessionId sessionId, List<LogRecord> records) throws IOException {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        if (logFile == null) {
            this.createLogFileAndAddToMap(sessionId);
            logFile = this.sessionToLogFileMap.get(sessionId);
        }
        logFile.openLogWriter();
        for (LogRecord record : records) {
            logFile.getLogWriter().writeObject(record);
        }
        logFile.closeLogWriter();
    }

    public List<LogRecord> getLogRecords(SessionId sessionId) throws IOException {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        if (logFile == null) {
            return new ArrayList<LogRecord>();
        }
        logFile.openLogReader();
        ObjectInputStream logObjInStream = logFile.getLogReader();
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        try {
            LogRecord tmpLogRecord;
            while ((tmpLogRecord = (LogRecord)logObjInStream.readObject()) != null) {
                logRecords.add(tmpLogRecord);
            }
        }
        catch (IOException iOException) {
            logFile.closeLogReader();
            return logRecords;
        }
        catch (ClassNotFoundException classNotFoundException) {
            logFile.closeLogReader();
            return logRecords;
        }
        logFile.closeLogReader();
        return logRecords;
    }

    public void removeLogFile(SessionId sessionId) {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        this.sessionToLogFileMap.remove(sessionId);
        if (logFile == null) {
            return;
        }
        try {
            logFile.removeLogFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class LogFile {
        private String logName;
        private ObjectOutputStream logWriter;
        private ObjectInputStream logReader;

        public LogFile(String logName) {
            this.logName = logName;
        }

        public void openLogWriter() throws IOException {
            this.logWriter = new ObjectOutputStream(new FileOutputStream(this.logName));
        }

        public void closeLogWriter() throws IOException {
            if (this.logWriter != null) {
                this.logWriter.close();
            }
        }

        public void openLogReader() throws IOException {
            this.logReader = new ObjectInputStream(new FileInputStream(this.logName));
        }

        public void closeLogReader() throws IOException {
            if (this.logReader != null) {
                this.logReader.close();
            }
        }

        public ObjectOutputStream getLogWriter() {
            return this.logWriter;
        }

        public ObjectInputStream getLogReader() {
            return this.logReader;
        }

        public void removeLogFile() throws IOException {
            if (this.logName != null) {
                this.closeLogReader();
                this.closeLogWriter();
                new File(this.logName).delete();
            }
        }
    }
}

