/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import java.io.IOException;
import java.util.Map;

public class HtmlCheckBoxInput
extends HtmlInput {
    private static final String DEFAULT_VALUE = "on";
    private boolean defaultCheckedState_;
    private boolean forceChecked_;

    HtmlCheckBoxInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, HtmlCheckBoxInput.addValueIfNeeded(page, attributes));
        if (this.getAttribute("value") == DEFAULT_VALUE) {
            this.setDefaultValue(ATTRIBUTE_NOT_DEFINED, false);
        }
        this.defaultCheckedState_ = this.hasAttribute("checked");
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        for (String key : attributes.keySet()) {
            if (!"value".equalsIgnoreCase(key)) continue;
            return attributes;
        }
        DomAttr newAttr = new DomAttr(page, null, "value", DEFAULT_VALUE, true);
        attributes.put("value", newAttr);
        return attributes;
    }

    @Override
    public void reset() {
        this.setChecked(this.defaultCheckedState_);
    }

    @Override
    public Page setChecked(boolean isChecked) {
        if (isChecked) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        if (this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS)) {
            return this.getPage();
        }
        return HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
    }

    @Override
    public String asText() {
        return super.asText();
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        boolean isChecked;
        boolean bl = isChecked = !this.isChecked();
        if (isChecked) {
            this.setAttribute("checked", "checked");
        } else {
            this.removeAttribute("checked");
        }
        super.doClickStateUpdate();
        return true;
    }

    @Override
    protected ScriptResult doClickFireClickEvent(Event event) throws IOException {
        if (!this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS) && !this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_AFTER_ONCLICK)) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
        return super.doClickFireClickEvent(event);
    }

    @Override
    protected void doClickFireChangeEvent() throws IOException {
        if (!this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS) && this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_AFTER_ONCLICK)) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    protected boolean isStateUpdateFirst() {
        return true;
    }

    @Override
    protected void preventDefault() {
        this.setChecked(!this.isChecked());
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
        this.defaultCheckedState_ = defaultChecked;
        this.setChecked(defaultChecked);
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_CHECKED_TO_FALSE_WHEN_CLONE)) {
            this.reset();
            this.forceChecked_ = true;
        }
    }

    @Override
    public boolean isDefaultChecked() {
        return this.defaultCheckedState_;
    }

    @Override
    protected void onAddedToPage() {
        super.onAddedToPage();
        if (this.forceChecked_) {
            this.reset();
            this.forceChecked_ = this.wasCreatedByJavascript();
        }
    }

    @Override
    protected void onAddedToDocumentFragment() {
        super.onAddedToDocumentFragment();
        if (this.forceChecked_) {
            this.reset();
            this.forceChecked_ = false;
        }
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlCheckBoxInput clone = (HtmlCheckBoxInput)super.cloneNode(deep);
        if (this.wasCreatedByJavascript() && this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_CHECKED_TO_FALSE_WHEN_CLONE)) {
            clone.removeAttribute("checked");
            clone.forceChecked_ = this.isDefaultChecked();
        }
        if (this.hasFeature(BrowserVersionFeatures.HTMLCHECKEDINPUT_SET_DEFAULT_VALUE_WHEN_CLONE)) {
            clone.setDefaultValue(this.getValueAttribute(), false);
        }
        return clone;
    }

    @Override
    Object getInternalValue() {
        return this.isChecked();
    }

    @Override
    void handleFocusLostValueChanged() {
        boolean fireOnChange = this.hasFeature(BrowserVersionFeatures.EVENT_ONCHANGE_LOSING_FOCUS);
        if (fireOnChange) {
            HtmlCheckBoxInput.executeOnChangeHandlerIfAppropriate(this);
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }
}

