/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.BaseAugmenter;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Augmenter
extends BaseAugmenter {
    private static final Logger logger = Logger.getLogger(Augmenter.class.getName());

    @Override
    protected <X> X create(RemoteWebDriver driver, Map<String, AugmenterProvider> augmentors, X objectToAugment) {
        CompoundHandler handler = this.determineAugmentation(driver, augmentors, objectToAugment);
        X augmented = this.performAugmentation(handler, objectToAugment);
        this.copyFields(objectToAugment.getClass(), objectToAugment, augmented);
        return augmented;
    }

    @Override
    protected RemoteWebDriver extractRemoteWebDriver(WebDriver driver) {
        if (driver.getClass().isAnnotationPresent(Augmentable.class) || driver.getClass().getName().startsWith("org.openqa.selenium.remote.RemoteWebDriver$$EnhancerByCGLIB")) {
            return (RemoteWebDriver)driver;
        }
        logger.warning("Augmenter should be applied to the instances of @Augmentable clases or previously augmented instances only");
        return null;
    }

    private void copyFields(Class<?> clazz, Object source, Object target) {
        if (Object.class.equals(clazz)) {
            return;
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            this.copyField(source, target, field);
            ++n2;
        }
        this.copyFields(clazz.getSuperclass(), source, target);
    }

    private void copyField(Object source, Object target, Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        if (field.getName().startsWith("CGLIB$")) {
            return;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(source);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate(e);
        }
    }

    private CompoundHandler determineAugmentation(RemoteWebDriver driver, Map<String, AugmenterProvider> augmentors, Object objectToAugment) {
        Map<String, ?> capabilities = driver.getCapabilities().asMap();
        CompoundHandler handler = new CompoundHandler(driver, objectToAugment);
        for (Map.Entry<String, ?> capabilityName : capabilities.entrySet()) {
            Object value;
            AugmenterProvider augmenter = augmentors.get(capabilityName.getKey());
            if (augmenter == null || (value = capabilityName.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            handler.addCapabilityHander(augmenter.getDescribedInterface(), augmenter.getImplementation(value));
        }
        return handler;
    }

    protected <X> X performAugmentation(CompoundHandler handler, X from) {
        if (handler.isNeedingApplication()) {
            Class<?> superClass = from.getClass();
            while (Enhancer.isEnhanced(superClass)) {
                superClass = superClass.getSuperclass();
            }
            Enhancer enhancer = new Enhancer();
            enhancer.setCallback(handler);
            enhancer.setSuperclass(superClass);
            HashSet<Class<?>> interfaces = Sets.newHashSet();
            interfaces.addAll(ImmutableList.copyOf(from.getClass().getInterfaces()));
            interfaces.addAll(handler.getInterfaces());
            enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            return (X)enhancer.create();
        }
        return from;
    }

    private class CompoundHandler
    implements MethodInterceptor {
        private Map<Method, InterfaceImplementation> handlers = new HashMap<Method, InterfaceImplementation>();
        private Set<Class<?>> interfaces = new HashSet();
        private final RemoteWebDriver driver;
        private final Object originalInstance;

        private CompoundHandler(RemoteWebDriver driver, Object originalInstance) {
            this.driver = driver;
            this.originalInstance = originalInstance;
        }

        public void addCapabilityHander(Class<?> fromInterface, InterfaceImplementation handledBy) {
            if (fromInterface.isInterface()) {
                this.interfaces.add(fromInterface);
            }
            Method[] methodArray = fromInterface.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                this.handlers.put(method, handledBy);
                ++n2;
            }
        }

        public Set<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        public boolean isNeedingApplication() {
            return !this.handlers.isEmpty();
        }

        @Override
        public Object intercept(Object self, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            InterfaceImplementation handler = this.handlers.get(method);
            if (handler == null) {
                try {
                    return method.invoke(this.originalInstance, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return handler.invoke(new RemoteExecuteMethod(this.driver), self, method, args);
        }
    }
}

