/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openqa.grid.common.CommandLineOptionHelper;
import org.openqa.grid.common.JSONConfigurationUtils;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.internal.utils.JsonKey;
import org.openqa.grid.internal.utils.ServerJsonValues;
import org.yaml.snakeyaml.Yaml;

public class GridHubConfiguration {
    private String host = null;
    private int port;
    private int cleanupCycle;
    private int newSessionWaitTimeout;
    private List<String> servlets = new ArrayList<String>();
    private Map<String, String> grid1Mapping = new HashMap<String, String>();
    private Prioritizer prioritizer = null;
    private CapabilityMatcher matcher = new DefaultCapabilityMatcher();
    private boolean throwOnCapabilityNotPresent = true;
    private String logFilename;
    private int jettyMaxThreads = -1;
    private boolean isDebug = false;
    private Map<String, Object> allParams = new HashMap<String, Object>();
    private String[] args = new String[0];
    private String grid1Yml = null;
    private String grid2JSON = null;

    public GridHubConfiguration() {
        this.loadDefault();
    }

    public static GridHubConfiguration build(String[] args) {
        String value;
        GridHubConfiguration res = new GridHubConfiguration();
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        res.args = args;
        if (helper.isParamPresent("-grid1Yml")) {
            res.grid1Yml = value = helper.getParamValue("-grid1Yml");
            res.loadFromGridYml(value);
        }
        if (helper.isParamPresent("-hubConfig")) {
            res.grid2JSON = value = helper.getParamValue("-hubConfig");
            res.loadFromJSON(value);
        }
        res.loadFromCommandLine(args);
        return res;
    }

    public String getGrid1Yml() {
        return this.grid1Yml;
    }

    public String getGrid2JSON() {
        return this.grid2JSON;
    }

    public void loadDefault() {
        this.loadFromJSON("defaults/DefaultHub.json");
    }

    public void loadFromCommandLine(String[] args) {
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        List<String> params = helper.getKeys();
        for (String param : params) {
            String cleanParam = param.replaceFirst("-", "");
            String value = helper.getParamValue(param);
            this.allParams.put(cleanParam, value);
        }
        if (helper.isParamPresent("-host")) {
            this.host = helper.getParamValue("-host");
        }
        if (helper.isParamPresent("-port")) {
            this.port = Integer.parseInt(helper.getParamValue("-port"));
        }
        if (helper.isParamPresent("-jettyMaxThreads")) {
            this.jettyMaxThreads = Integer.parseInt(helper.getParamValue("-jettyMaxThreads"));
        }
        if (helper.isParamPresent("-cleanUpCycle")) {
            this.cleanupCycle = Integer.parseInt(helper.getParamValue("-cleanUpCycle"));
        }
        if (helper.isParamPresent(ServerJsonValues.CLIENT_TIMEOUT.getAsParam())) {
            this.setTimeout(Integer.parseInt(helper.getParamValue(ServerJsonValues.CLIENT_TIMEOUT.getAsParam())) * 1000);
        }
        if (helper.isParamPresent(ServerJsonValues.BROWSER_TIMEOUT.getAsParam())) {
            this.setBrowserTimeout(Integer.parseInt(helper.getParamValue(ServerJsonValues.BROWSER_TIMEOUT.getAsParam())) * 1000);
        }
        if (helper.isParamPresent("-newSessionWaitTimeout")) {
            this.newSessionWaitTimeout = Integer.parseInt(helper.getParamValue("-newSessionWaitTimeout"));
        }
        if (helper.isParamPresent("-throwOnCapabilityNotPresent")) {
            this.throwOnCapabilityNotPresent = Boolean.parseBoolean(helper.getParamValue("-throwOnCapabilityNotPresent"));
        }
        if (helper.isParamPresent("-prioritizer")) {
            this.setPrioritizer(helper.getParamValue("-prioritizer"));
        }
        if (helper.isParamPresent("-capabilityMatcher")) {
            this.setCapabilityMatcher(helper.getParamValue("-capabilityMatcher"));
        }
        if (helper.isParamPresent("-servlets")) {
            this.servlets = helper.getParamValues("-servlets");
        }
        if (helper.isParamPresent("-log")) {
            this.logFilename = helper.getParamValue("-log");
        }
        if (helper.isParamPresent("-debug")) {
            this.isDebug = true;
        }
    }

    public void loadFromGridYml(String resource) {
        Integer newSessionWait;
        Integer port;
        Integer timeout;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (in == null) {
            try {
                in = new FileInputStream(resource);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (in == null) {
            throw new InvalidParameterException(String.valueOf(resource) + " is not a valid resource.");
        }
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(in);
        Map hub = (Map)config.get("hub");
        List environments = (List)hub.get("environments");
        Integer p = (Integer)hub.get("port");
        if (p != null) {
            this.port = p;
        }
        for (Map environment : environments) {
            this.getGrid1Mapping().put((String)environment.get("name"), (String)environment.get("browser"));
        }
        Integer poll = (Integer)hub.get("remoteControlPollingIntervalInSeconds");
        if (poll != null) {
            this.allParams.put("nodePolling", poll * 1000);
            this.cleanupCycle = poll * 1000;
        }
        if ((timeout = (Integer)hub.get("sessionMaxIdleTimeInSeconds")) != null) {
            this.setTimeout(timeout * 1000);
        }
        if ((port = (Integer)hub.get("port")) != null) {
            this.setPort(port);
        }
        if ((newSessionWait = (Integer)hub.get("newSessionMaxWaitTimeInSeconds")) != null) {
            this.setNewSessionWaitTimeout(newSessionWait * 1000);
        }
        this.allParams.put("maxSession", 1);
    }

    public void loadFromJSON(String resource) {
        try {
            JSONObject o = JSONConfigurationUtils.loadJSON(resource);
            if (o.has("host") && !o.isNull("host")) {
                this.host = o.getString("host");
            }
            if (o.has("port") && !o.isNull("port")) {
                this.port = o.getInt("port");
            }
            if (o.has("cleanUpCycle") && !o.isNull("cleanUpCycle")) {
                this.cleanupCycle = o.getInt("cleanUpCycle");
            }
            if (o.has("timeout") && !o.isNull("timeout")) {
                this.setTimeout(o.getInt("timeout"));
            }
            if (o.has("browserTimeout") && !o.isNull("browserTimeout")) {
                this.setBrowserTimeout(o.getInt("browserTimeout"));
            }
            if (o.has("newSessionWaitTimeout") && !o.isNull("newSessionWaitTimeout")) {
                this.newSessionWaitTimeout = o.getInt("newSessionWaitTimeout");
            }
            if (o.has("servlets") && !o.isNull("servlets")) {
                JSONArray jsservlets = o.getJSONArray("servlets");
                int i = 0;
                while (i < jsservlets.length()) {
                    this.servlets.add(jsservlets.getString(i));
                    ++i;
                }
            }
            if (o.has("jettyMaxThreads") && !o.isNull("jettyMaxThreads")) {
                this.jettyMaxThreads = o.getInt("jettyMaxThreads");
            }
            if (o.has("prioritizer") && !o.isNull("prioritizer")) {
                String prioritizerClass = o.getString("prioritizer");
                this.setPrioritizer(prioritizerClass);
            }
            if (o.has("capabilityMatcher") && !o.isNull("capabilityMatcher")) {
                String capabilityMatcherClass = o.getString("capabilityMatcher");
                this.setCapabilityMatcher(capabilityMatcherClass);
            }
            if (o.has("throwOnCapabilityNotPresent") && !o.isNull("throwOnCapabilityNotPresent")) {
                this.throwOnCapabilityNotPresent = o.getBoolean("throwOnCapabilityNotPresent");
            }
            Iterator iterator = o.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = o.get(key);
                if (value instanceof JSONArray) {
                    JSONArray a = (JSONArray)value;
                    ArrayList<String> as = new ArrayList<String>();
                    int i = 0;
                    while (i < a.length()) {
                        as.add(a.getString(i));
                        ++i;
                    }
                    this.allParams.put(key, as);
                    continue;
                }
                this.allParams.put(key, o.get(key));
            }
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getCleanupCycle() {
        return this.cleanupCycle;
    }

    public int getTimeout() {
        return this.getIntWith0Default(ServerJsonValues.CLIENT_TIMEOUT);
    }

    public int getBrowserTimeout() {
        return this.getIntWith0Default(ServerJsonValues.BROWSER_TIMEOUT);
    }

    public void setBrowserTimeout(int browserTimeout) {
        this.put(ServerJsonValues.BROWSER_TIMEOUT, browserTimeout);
    }

    public int getNewSessionWaitTimeout() {
        return this.newSessionWaitTimeout;
    }

    public List<String> getServlets() {
        return this.servlets;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public Map<String, String> getGrid1Mapping() {
        return this.grid1Mapping;
    }

    public Prioritizer getPrioritizer() {
        return this.prioritizer;
    }

    public CapabilityMatcher getCapabilityMatcher() {
        return this.matcher;
    }

    public boolean isThrowOnCapabilityNotPresent() {
        return this.throwOnCapabilityNotPresent;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCleanupCycle(int cleanupCycle) {
        this.cleanupCycle = cleanupCycle;
    }

    public void setTimeout(int timeout) {
        this.put(ServerJsonValues.CLIENT_TIMEOUT, timeout);
    }

    private void put(JsonKey key, Object value) {
        this.allParams.put(key.getKey(), value);
    }

    private <T> T get(JsonKey jsonKey) {
        return (T)this.allParams.get(jsonKey.getKey());
    }

    private Integer getIntWith0Default(JsonKey jsonKey) {
        Object o = this.allParams.get(jsonKey.getKey());
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        return o != null ? (Integer)o : 0;
    }

    public void setNewSessionWaitTimeout(int newSessionWaitTimeout) {
        this.newSessionWaitTimeout = newSessionWaitTimeout;
    }

    public void setServlets(List<String> servlets) {
        this.servlets = servlets;
    }

    public void setPrioritizer(String prioritizerClass) {
        try {
            Class<?> p = Class.forName(prioritizerClass);
            Class[] argsClass = new Class[]{};
            Constructor<?> c = p.getConstructor(argsClass);
            Object[] args = new Object[]{};
            this.prioritizer = (Prioritizer)c.newInstance(args);
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error creating the prioritize from class " + prioritizerClass + " : " + e.getMessage(), e);
        }
    }

    public void setPrioritizer(Prioritizer prioritizer) {
        this.prioritizer = prioritizer;
    }

    public void setCapabilityMatcher(String matcherClass) {
        try {
            Class<?> p = Class.forName(matcherClass);
            Class[] argsClass = new Class[]{};
            Constructor<?> c = p.getConstructor(argsClass);
            Object[] args = new Object[]{};
            this.matcher = (CapabilityMatcher)c.newInstance(args);
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error creating the capability matcher from class " + matcherClass + " : " + e.getMessage(), e);
        }
    }

    public void setCapabilityMatcher(CapabilityMatcher matcher) {
        this.matcher = matcher;
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String prettyPrint() {
        StringBuilder b = new StringBuilder();
        b.append("host: ").append(this.host).append("\n");
        b.append("port: ").append(this.port).append("\n");
        b.append("cleanupCycle: ").append(this.cleanupCycle).append("\n");
        b.append("timeout: ").append(this.getTimeout()).append("\n");
        b.append("browserTimeout: ").append(this.getBrowserTimeout()).append("\n");
        b.append("newSessionWaitTimeout: ").append(this.newSessionWaitTimeout).append("\n");
        b.append("grid1Mapping: ").append(this.grid1Mapping).append("\n");
        b.append("throwOnCapabilityNotPresent: ").append(this.throwOnCapabilityNotPresent).append("\n");
        b.append("capabilityMatcher: ").append(this.matcher == null ? "null" : this.matcher.getClass().getCanonicalName()).append("\n");
        b.append("prioritizer: ").append(this.prioritizer == null ? "null" : this.prioritizer.getClass().getCanonicalName()).append("\n");
        b.append("servlets: ");
        for (String s : this.servlets) {
            b.append(s.getClass().getCanonicalName()).append(",");
        }
        b.append("\n\n");
        b.append("all params :\n");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.allParams.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            b.append(s.replaceFirst("-", "")).append(":").append(this.allParams.get(s)).append("\n");
        }
        return b.toString();
    }

    public Map<String, Object> getAllParams() {
        return this.allParams;
    }

    public int getJettyMaxThreads() {
        return this.jettyMaxThreads;
    }
}

