/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlFileInput
extends HtmlInput {
    private String contentType_;
    private byte[] data_;

    HtmlFileInput(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, HtmlFileInput.addValueIfNeeded(page, attributes));
        if (this.hasFeature(BrowserVersionFeatures.FILEINPUT_EMPTY_DEFAULT_VALUE)) {
            this.setDefaultValue("", false);
        } else {
            for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
                if (!"value".equalsIgnoreCase(entry.getKey())) continue;
                this.setDefaultValue(entry.getValue().getNodeValue(), false);
            }
        }
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        HashMap<String, DomAttr> result = new HashMap<String, DomAttr>(attributes);
        DomAttr newAttr = new DomAttr(page, null, "value", "", true);
        result.put("value", newAttr);
        return result;
    }

    public final byte[] getData() {
        return this.data_;
    }

    public final void setData(byte[] data) {
        this.data_ = data;
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String value = this.getValueAttribute();
        if (StringUtils.isEmpty(value)) {
            return new NameValuePair[]{new KeyDataPair(this.getNameAttribute(), new File(""), null, null)};
        }
        File file = null;
        if (value.startsWith("file:/")) {
            if (value.startsWith("file://") && !value.startsWith("file:///")) {
                value = "file:///" + value.substring(7);
            }
            try {
                file = new File(new URI(value));
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        if (file == null) {
            file = new File(value);
        }
        String contentType = this.contentType_ == null ? this.getPage().getWebClient().guessContentType(file) : this.contentType_;
        String charset = this.getPage().getPageEncoding();
        KeyDataPair keyDataPair = new KeyDataPair(this.getNameAttribute(), file, contentType, charset);
        keyDataPair.setData(this.data_);
        return new NameValuePair[]{keyDataPair};
    }

    @Override
    public void reset() {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue, false);
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    public String getContentType() {
        return this.contentType_;
    }
}

