/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";

    private ChromeDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static ChromeDriverService createDefaultService() {
        File exe = ChromeDriverService.findExecutable("chromedriver", CHROME_DRIVER_EXE_PROPERTY, "http://code.google.com/p/selenium/wiki/ChromeDriver", "http://code.google.com/p/chromedriver/downloads/list");
        return new Builder().usingDriverExecutable(exe).usingAnyFreePort().build();
    }

    /* synthetic */ ChromeDriverService(File file, int n, ImmutableList immutableList, ImmutableMap immutableMap, ChromeDriverService chromeDriverService) throws IOException {
        this(file, n, immutableList, immutableMap);
    }

    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull(file);
            ChromeDriverService.checkExecutable(file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument(port >= 0, "Invalid port number: %d", port);
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public ChromeDriverService build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            Preconditions.checkState(this.exe != null, "Path to the driver executable not specified");
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                argsBuilder.add(String.format("--port=%d", this.port));
                if (this.logFile != null) {
                    argsBuilder.add(String.format("--log-path=%s", this.logFile.getAbsolutePath()));
                }
                return new ChromeDriverService(this.exe, this.port, (ImmutableList)argsBuilder.build(), this.environment, null);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

