/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.SafariLocator;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriverConnection;
import org.openqa.selenium.safari.SafariDriverExtension;
import org.openqa.selenium.safari.SafariDriverServer;
import org.openqa.selenium.safari.SessionData;

class SafariDriverCommandExecutor
implements CommandExecutor {
    private final SafariDriverExtension extension;
    private final SafariDriverServer server;
    private final BrowserLocator browserLocator;
    private final SessionData sessionData;
    private final boolean cleanSession;
    private CommandLine commandLine;
    private SafariDriverConnection connection;

    SafariDriverCommandExecutor(int port, boolean cleanSession, SafariDriverExtension extension) {
        this.extension = (SafariDriverExtension)Preconditions.checkNotNull((Object)extension, (Object)"null extension");
        this.server = new SafariDriverServer(port);
        this.browserLocator = new SafariLocator();
        this.sessionData = SessionData.forCurrentPlatform();
        this.cleanSession = cleanSession;
    }

    void start() throws IOException {
        if (this.commandLine != null) {
            return;
        }
        this.server.start();
        this.extension.install();
        if (this.cleanSession) {
            this.sessionData.clear();
        }
        File connectFile = this.prepareConnectFile(this.server.getUri());
        BrowserInstallation installation = this.browserLocator.findBrowserLocationOrFail();
        this.commandLine = new CommandLine(installation.launcherFilePath(), new String[]{connectFile.getAbsolutePath()});
        this.commandLine.executeAsync();
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        try {
            this.connection = this.server.getConnection(45L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
        if (this.connection == null) {
            this.stop();
            throw new UnreachableBrowserException(String.format("Failed to connect to SafariDriver after %d ms", stopwatch.elapsed(TimeUnit.MILLISECONDS)));
        }
    }

    private File prepareConnectFile(String serverUri) throws IOException {
        File tmpDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("anonymous", "safaridriver");
        File launchFile = new File(tmpDir, "connect.html");
        launchFile.deleteOnExit();
        String contents = String.format("<!DOCTYPE html><script>window.location = '%s';</script>", serverUri);
        Files.write((CharSequence)contents, (File)launchFile, (Charset)Charsets.UTF_8);
        return launchFile;
    }

    void stop() {
        if (this.commandLine != null) {
            this.commandLine.destroy();
            this.commandLine = null;
        }
        this.server.stop();
        this.connection = null;
        try {
            this.extension.uninstall();
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to uninstall extension", (Throwable)e);
        }
    }

    public Response execute(Command command) {
        if (!this.server.isRunning() && "quit".equals(command.getName())) {
            Response itsOkToQuitMultipleTimes = new Response();
            itsOkToQuitMultipleTimes.setStatus(0);
            return itsOkToQuitMultipleTimes;
        }
        Preconditions.checkState((this.connection != null ? 1 : 0) != 0, (Object)"Executor has not been started yet");
        try {
            return this.connection.send(command);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

