/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.io.IOException;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriverCommandExecutor;

@Beta
public class SafariDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public SafariDriver() {
        super((CommandExecutor)new SafariDriverCommandExecutor(0), (Capabilities)DesiredCapabilities.safari());
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    protected void startClient() {
        SafariDriverCommandExecutor executor = (SafariDriverCommandExecutor)this.getCommandExecutor();
        try {
            executor.start();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected void stopClient() {
        SafariDriverCommandExecutor executor = (SafariDriverCommandExecutor)this.getCommandExecutor();
        executor.stop();
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        String base64 = (String)this.execute("screenshot").getValue();
        return (X)target.convertFromBase64Png(base64);
    }
}

