/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.script.LocalValue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class RegExpValue
extends LocalValue {
    private final String pattern;
    private final @Nullable String flags;

    public RegExpValue(String pattern) {
        this(pattern, null);
    }

    public RegExpValue(String pattern, @Nullable String flags) {
        this.pattern = pattern;
        this.flags = flags;
    }

    public static RegExpValue fromJson(JsonInput input) {
        String pattern = null;
        String flags = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "pattern": {
                    pattern = (String)input.read(String.class);
                    continue block8;
                }
                case "flags": {
                    flags = (String)input.read(String.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RegExpValue((String)Require.nonNull((String)"pattern", pattern), flags);
    }

    @Override
    public Map<String, Object> toJson() {
        Map<String, String> value = this.flags == null ? Map.of("pattern", this.pattern) : Map.of("pattern", this.pattern, "flags", this.flags);
        return Map.of("type", "regexp", "value", value);
    }

    public String getPattern() {
        return this.pattern;
    }

    public @Nullable String getFlags() {
        return this.flags;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RegExpValue)) {
            return false;
        }
        RegExpValue other = (RegExpValue)object;
        return Objects.equals(this.pattern, other.pattern) && Objects.equals(this.flags, other.flags);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.flags);
    }

    public String toString() {
        return String.format("%s{pattern:%s, flags:%s}", this.getClass().getSimpleName(), this.pattern, this.flags);
    }
}

