/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class NodeProperties {
    private final long nodeType;
    private final long childNodeCount;
    private final Optional<Map<String, String>> attributes;
    private final Optional<List<RemoteValue>> children;
    private final Optional<String> localName;
    private final Optional<Mode> mode;
    private final Optional<String> namespaceURI;
    private final Optional<String> nodeValue;
    private final Optional<RemoteValue> shadowRoot;

    private NodeProperties(long nodeType, long childNodeCount, Optional<Map<String, String>> attributes, Optional<List<RemoteValue>> children, Optional<String> localName, Optional<Mode> mode, Optional<String> namespaceURI, Optional<String> nodeValue, Optional<RemoteValue> shadowRoot) {
        this.nodeType = Require.nonNegative((String)"nodeType", (Long)nodeType);
        this.childNodeCount = Require.nonNegative((String)"childNodeCount", (Long)childNodeCount);
        this.attributes = attributes;
        this.children = children;
        this.localName = localName;
        this.mode = mode;
        this.namespaceURI = namespaceURI;
        this.nodeValue = nodeValue;
        this.shadowRoot = shadowRoot;
    }

    public static NodeProperties fromJson(JsonInput input) {
        Long nodeType = null;
        Long childNodeCount = null;
        Optional<Map<String, String>> attributes = Optional.empty();
        Optional<List<RemoteValue>> children = Optional.empty();
        Optional<String> localName = Optional.empty();
        Optional<Mode> mode = Optional.empty();
        Optional<String> namespaceURI = Optional.empty();
        Optional<String> nodeValue = Optional.empty();
        Optional<RemoteValue> shadowRoot = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeType": {
                    nodeType = (Long)input.read(Long.class);
                    continue block22;
                }
                case "childNodeCount": {
                    childNodeCount = (Long)input.read(Long.class);
                    continue block22;
                }
                case "attributes": {
                    attributes = Optional.of((Map)input.readNonNull(new TypeToken<Map<String, String>>(){}.getType()));
                    continue block22;
                }
                case "children": {
                    children = Optional.of((List)input.readNonNull(new TypeToken<List<RemoteValue>>(){}.getType()));
                    continue block22;
                }
                case "localName": {
                    localName = Optional.of((String)input.readNonNull(String.class));
                    continue block22;
                }
                case "mode": {
                    mode = Optional.of(Mode.findByName((String)input.readNonNull(String.class)));
                    continue block22;
                }
                case "namespaceURI": {
                    namespaceURI = Optional.of((String)input.readNonNull(String.class));
                    continue block22;
                }
                case "nodeValue": {
                    nodeValue = Optional.of((String)input.readNonNull(String.class));
                    continue block22;
                }
                case "shadowRoot": {
                    shadowRoot = Optional.ofNullable((RemoteValue)input.read(RemoteValue.class));
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodeProperties(Require.nonNegative((String)"nodeType", nodeType), Require.nonNegative((String)"childNodeCount", childNodeCount), attributes, children, localName, mode, namespaceURI, nodeValue, shadowRoot);
    }

    public long getNodeType() {
        return this.nodeType;
    }

    public long getChildNodeCount() {
        return this.childNodeCount;
    }

    public Optional<Map<String, String>> getAttributes() {
        return this.attributes;
    }

    public Optional<List<RemoteValue>> getChildren() {
        return this.children;
    }

    public Optional<String> getLocalName() {
        return this.localName;
    }

    public Optional<Mode> getMode() {
        return this.mode;
    }

    public Optional<String> getNamespaceURI() {
        return this.namespaceURI;
    }

    public Optional<String> getNodeValue() {
        return this.nodeValue;
    }

    public Optional<RemoteValue> getShadowRoot() {
        return this.shadowRoot;
    }

    public static enum Mode {
        OPEN("open"),
        CLOSED("closed");

        private final String value;

        private Mode(String mode) {
            this.value = mode;
        }

        public String toString() {
            return this.value;
        }

        public static Mode findByName(String name) {
            for (Mode type : Mode.values()) {
                if (!type.toString().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("Unsupported node mode: " + name);
        }
    }
}

