/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.network.AuthChallenge;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class ResponseData {
    private final String url;
    private final String protocol;
    private final int status;
    private final String statusText;
    private final boolean fromCache;
    private final List<Header> headers;
    private final String mimeType;
    private final long bytesReceived;
    private final @Nullable Long headersSize;
    private final @Nullable Long bodySize;
    private final @Nullable Long contentSize;
    private final @Nullable AuthChallenge authChallenge;

    private ResponseData(String url, String protocol, int status, String statusText, boolean fromCache, List<Header> headers, String mimeType, long bytesReceived, @Nullable Long headersSize, @Nullable Long bodySize, @Nullable Long contentSize, @Nullable AuthChallenge authChallenge) {
        this.url = url;
        this.protocol = protocol;
        this.status = status;
        this.statusText = statusText;
        this.fromCache = fromCache;
        this.headers = headers;
        this.mimeType = mimeType;
        this.bytesReceived = bytesReceived;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.contentSize = contentSize;
        this.authChallenge = authChallenge;
    }

    public static ResponseData fromJson(JsonInput input) {
        String url = null;
        String protocol = null;
        Integer status = null;
        String statusText = null;
        Boolean fromCache = null;
        List headers = new ArrayList();
        String mimeType = null;
        Long bytesReceived = null;
        Long headersSize = null;
        Long bodySize = null;
        Long contentSize = null;
        AuthChallenge authChallenge = null;
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = (String)input.read(String.class);
                    continue block28;
                }
                case "protocol": {
                    protocol = (String)input.read(String.class);
                    continue block28;
                }
                case "status": {
                    status = (Integer)input.read(Integer.class);
                    continue block28;
                }
                case "statusText": {
                    statusText = (String)input.read(String.class);
                    continue block28;
                }
                case "fromCache": {
                    fromCache = (Boolean)input.read(Boolean.class);
                    continue block28;
                }
                case "headers": {
                    headers = (List)input.read(new TypeToken<List<Header>>(){}.getType());
                    continue block28;
                }
                case "mimeType": {
                    mimeType = (String)input.read(String.class);
                    continue block28;
                }
                case "bytesReceived": {
                    bytesReceived = (Long)input.read(Long.class);
                    continue block28;
                }
                case "headersSize": {
                    headersSize = (Long)input.read(Long.class);
                    continue block28;
                }
                case "bodySize": {
                    bodySize = (Long)input.read(Long.class);
                    continue block28;
                }
                case "content": {
                    contentSize = (Long)input.readMapElement("size");
                    continue block28;
                }
                case "authChallenge": {
                    authChallenge = (AuthChallenge)input.read(AuthChallenge.class);
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResponseData((String)Require.nonNull((String)"url", url), (String)Require.nonNull((String)"protocol", protocol), (Integer)Require.nonNull((String)"status", (Object)status), (String)Require.nonNull((String)"statusText", (Object)statusText), (Boolean)Require.nonNull((String)"fromCache", (Object)fromCache), (List)Require.nonNull((String)"headers", headers), (String)Require.nonNull((String)"mimeType", (Object)mimeType), (Long)Require.nonNull((String)"bytesReceived", (Object)bytesReceived), headersSize, bodySize, contentSize, authChallenge);
    }

    public String getUrl() {
        return this.url;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public boolean isFromCache() {
        return this.fromCache;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public @Nullable Long getHeadersSize() {
        return this.headersSize;
    }

    public @Nullable Long getBodySize() {
        return this.bodySize;
    }

    public Optional<Long> getContent() {
        return Optional.ofNullable(this.contentSize);
    }

    public Optional<AuthChallenge> getAuthChallenge() {
        return Optional.ofNullable(this.authChallenge);
    }
}

