/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.script.CallFunctionParameters;
import org.openqa.selenium.bidi.script.ChannelValue;
import org.openqa.selenium.bidi.script.EvaluateParameters;
import org.openqa.selenium.bidi.script.EvaluateResult;
import org.openqa.selenium.bidi.script.EvaluateResultExceptionValue;
import org.openqa.selenium.bidi.script.EvaluateResultSuccess;
import org.openqa.selenium.bidi.script.ExceptionDetails;
import org.openqa.selenium.bidi.script.LocalValue;
import org.openqa.selenium.bidi.script.Message;
import org.openqa.selenium.bidi.script.RealmInfo;
import org.openqa.selenium.bidi.script.RealmType;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.bidi.script.ResultOwnership;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class Script
implements Closeable {
    private final Set<String> browsingContextIds;
    private static final Json JSON = new Json();
    private final BiDi bidi;
    private static final Function<JsonInput, EvaluateResult> evaluateResultMapper = jsonInput -> Script.createEvaluateResult(jsonInput.readMap());
    private static final Function<JsonInput, List<RealmInfo>> realmInfoMapper = jsonInput -> {
        Object realms = jsonInput.readMapElement("realms");
        try (StringReader reader = new StringReader(JSON.toJson(realms));){
            List list;
            block11: {
                JsonInput input = JSON.newInput((Reader)reader);
                try {
                    list = (List)input.readNonNull(new TypeToken<List<RealmInfo>>(){}.getType());
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return list;
        }
    };
    private static final Event<Message> messageEvent = new Event<Message>("script.message", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            Message message;
            block11: {
                JsonInput input = JSON.newInput((Reader)reader);
                try {
                    message = (Message)input.readNonNull(Message.class);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return message;
        }
    });
    private static final Event<RealmInfo> realmCreated = new Event<RealmInfo>("script.realmCreated", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            RealmInfo realmInfo;
            block11: {
                JsonInput input = JSON.newInput((Reader)reader);
                try {
                    realmInfo = (RealmInfo)input.readNonNull(RealmInfo.class);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return realmInfo;
        }
    });
    private static final Event<RealmInfo> realmDestroyed = new Event<RealmInfo>("script.realmDestroyed", params -> {
        try (StringReader reader = new StringReader(JSON.toJson(params));){
            RealmInfo realmInfo;
            block11: {
                JsonInput input = JSON.newInput((Reader)reader);
                try {
                    realmInfo = (RealmInfo)input.readNonNull(RealmInfo.class);
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return realmInfo;
        }
    });

    public Script(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public Script(String browsingContextId, WebDriver driver) {
        this(Collections.singleton((String)Require.nonNull((String)"Browsing context id", (Object)browsingContextId)), driver);
    }

    public Script(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.browsingContextIds = browsingContextIds;
    }

    public EvaluateResult callFunction(CallFunctionParameters parameters) {
        return this.bidi.send(new Command<EvaluateResult>("script.callFunction", parameters.toMap(), evaluateResultMapper));
    }

    public EvaluateResult callFunctionInRealm(String realmId, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> arguments, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getCallFunctionParams("realm", realmId, null, functionDeclaration, awaitPromise, arguments, thisParameter, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.callFunction", params, evaluateResultMapper));
    }

    public EvaluateResult callFunctionInBrowsingContext(String browsingContextId, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> argumentValueList, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        return this.callFunctionInBrowsingContext(browsingContextId, null, functionDeclaration, awaitPromise, argumentValueList, thisParameter, resultOwnership);
    }

    public EvaluateResult callFunctionInBrowsingContext(String browsingContextId, @Nullable String sandbox, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> argumentValueList, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getCallFunctionParams("contextTarget", browsingContextId, sandbox, functionDeclaration, awaitPromise, argumentValueList, thisParameter, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.callFunction", params, evaluateResultMapper));
    }

    public EvaluateResult evaluateFunction(EvaluateParameters parameters) {
        return this.bidi.send(new Command<EvaluateResult>("script.evaluate", parameters.toMap(), evaluateResultMapper));
    }

    public EvaluateResult evaluateFunctionInRealm(String realmId, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getEvaluateParams("realm", realmId, null, expression, awaitPromise, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.evaluate", params, evaluateResultMapper));
    }

    public EvaluateResult evaluateFunctionInBrowsingContext(String browsingContextId, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        return this.evaluateFunctionInBrowsingContext(browsingContextId, null, expression, awaitPromise, resultOwnership);
    }

    public EvaluateResult evaluateFunctionInBrowsingContext(String browsingContextId, @Nullable String sandbox, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        Map<String, Object> params = this.getEvaluateParams("contextTarget", browsingContextId, sandbox, expression, awaitPromise, resultOwnership);
        return this.bidi.send(new Command<EvaluateResult>("script.evaluate", params, evaluateResultMapper));
    }

    public void disownRealmScript(String realmId, List<String> handles) {
        this.bidi.send(new Command("script.disown", Map.of("handles", handles, "target", Map.of("realm", realmId))));
    }

    public void disownBrowsingContextScript(String browsingContextId, List<String> handles) {
        this.bidi.send(new Command("script.disown", Map.of("handles", handles, "target", Map.of("context", browsingContextId))));
    }

    public void disownBrowsingContextScript(String browsingContextId, String sandbox, List<String> handles) {
        this.bidi.send(new Command("script.disown", Map.of("handles", handles, "target", Map.of("context", browsingContextId, "sandbox", sandbox))));
    }

    public List<RealmInfo> getAllRealms() {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Collections.emptyMap(), realmInfoMapper));
    }

    public List<RealmInfo> getRealmsByType(RealmType type) {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Map.of("type", type.toString()), realmInfoMapper));
    }

    public List<RealmInfo> getRealmsInBrowsingContext(String browsingContext) {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Map.of("context", browsingContext), realmInfoMapper));
    }

    public List<RealmInfo> getRealmsInBrowsingContextByType(String browsingContext, RealmType type) {
        return this.bidi.send(new Command<List<RealmInfo>>("script.getRealms", Map.of("context", browsingContext, "type", type.toString()), realmInfoMapper));
    }

    public String addPreloadScript(String functionDeclaration) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("functionDeclaration", functionDeclaration);
        if (!this.browsingContextIds.isEmpty()) {
            parameters.put("contexts", this.browsingContextIds);
        }
        return this.bidi.send(new Command<String>("script.addPreloadScript", parameters, jsonInput -> jsonInput.readMapElement("script").toString()));
    }

    public String addPreloadScript(String functionDeclaration, List<ChannelValue> arguments) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("functionDeclaration", functionDeclaration);
        parameters.put("arguments", arguments);
        if (!this.browsingContextIds.isEmpty()) {
            parameters.put("contexts", this.browsingContextIds);
        }
        return this.bidi.send(new Command<String>("script.addPreloadScript", parameters, jsonInput -> (String)jsonInput.readMapElement("script")));
    }

    public String addPreloadScript(String functionDeclaration, String sandbox) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("functionDeclaration", functionDeclaration);
        parameters.put("sandbox", sandbox);
        if (!this.browsingContextIds.isEmpty()) {
            parameters.put("contexts", this.browsingContextIds);
        }
        return this.bidi.send(new Command<String>("script.addPreloadScript", parameters, jsonInput -> jsonInput.readMapElement("script").toString()));
    }

    public String addPreloadScript(String functionDeclaration, List<ChannelValue> arguments, String sandbox) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(4);
        parameters.put("functionDeclaration", functionDeclaration);
        parameters.put("arguments", arguments);
        parameters.put("sandbox", sandbox);
        if (!this.browsingContextIds.isEmpty()) {
            parameters.put("contexts", this.browsingContextIds);
        }
        return this.bidi.send(new Command<String>("script.addPreloadScript", parameters, jsonInput -> jsonInput.readMapElement("script").toString()));
    }

    public void removePreloadScript(String id) {
        this.bidi.send(new Command("script.removePreloadScript", Map.of("script", id)));
    }

    public long onMessage(Consumer<Message> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            return this.bidi.addListener(messageEvent, consumer);
        }
        return this.bidi.addListener(this.browsingContextIds, messageEvent, consumer);
    }

    public void onRealmCreated(Consumer<RealmInfo> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(realmCreated, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, realmCreated, consumer);
        }
    }

    public void onRealmDestroyed(Consumer<RealmInfo> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(realmDestroyed, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, realmDestroyed, consumer);
        }
    }

    private Map<String, Object> getCallFunctionParams(String targetType, String id, @Nullable String sandbox, String functionDeclaration, boolean awaitPromise, Optional<List<LocalValue>> argumentValueList, Optional<LocalValue> thisParameter, Optional<ResultOwnership> resultOwnership) {
        HashMap<String, Object> params = new HashMap<String, Object>(7);
        params.put("functionDeclaration", functionDeclaration);
        params.put("awaitPromise", awaitPromise);
        if (targetType.equals("contextTarget")) {
            if (sandbox != null) {
                params.put("target", Map.of("context", id, "sandbox", sandbox));
            } else {
                params.put("target", Map.of("context", id));
            }
        } else {
            params.put("target", Map.of("realm", id));
        }
        argumentValueList.ifPresent(argumentValues -> params.put("arguments", argumentValues));
        thisParameter.ifPresent(value -> params.put("this", value));
        resultOwnership.ifPresent(value -> params.put("resultOwnership", value.toString()));
        return params;
    }

    private Map<String, Object> getEvaluateParams(String targetType, String id, @Nullable String sandbox, String expression, boolean awaitPromise, Optional<ResultOwnership> resultOwnership) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("expression", expression);
        params.put("awaitPromise", awaitPromise);
        if (targetType.equals("contextTarget")) {
            if (sandbox != null) {
                params.put("target", Map.of("context", id, "sandbox", sandbox));
            } else {
                params.put("target", Map.of("context", id));
            }
        } else {
            params.put("target", Map.of("realm", id));
        }
        resultOwnership.ifPresent(value -> params.put("resultOwnership", value.toString()));
        return params;
    }

    private static EvaluateResult createEvaluateResult(Map<String, Object> response) {
        EvaluateResult evaluateResult;
        String type = (String)response.get("type");
        String realmId = (String)response.get("realm");
        if (type.equals(EvaluateResult.Type.SUCCESS.toString())) {
            RemoteValue remoteValue;
            try (StringReader reader = new StringReader(JSON.toJson(response.get("result")));
                 JsonInput input = JSON.newInput((Reader)reader);){
                remoteValue = (RemoteValue)input.readNonNull(RemoteValue.class);
            }
            evaluateResult = new EvaluateResultSuccess(EvaluateResult.Type.SUCCESS, realmId, remoteValue);
        } else {
            ExceptionDetails exceptionDetails;
            try (StringReader reader = new StringReader(JSON.toJson(response.get("exceptionDetails")));
                 JsonInput input = JSON.newInput((Reader)reader);){
                exceptionDetails = (ExceptionDetails)input.readNonNull(ExceptionDetails.class);
            }
            evaluateResult = new EvaluateResultExceptionValue(EvaluateResult.Type.EXCEPTION, realmId, exceptionDetails);
        }
        return evaluateResult;
    }

    @Override
    public void close() {
        this.bidi.clearListener(messageEvent);
    }
}

