/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.emulation;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.internal.Require;

public class GeolocationCoordinates {
    private static final String ALTITUDE = "altitude";
    private static final double DEFAULT_ACCURACY = 1.0;
    private static final String ALTITUDE_ACCURACY = "altitudeAccuracy";
    private static final String HEADING = "heading";
    private static final String SPEED = "speed";
    private static final String ACCURACY = "accuracy";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private final Map<String, Object> map = new HashMap<String, Object>();

    public GeolocationCoordinates(double latitude, double longitude) {
        Require.inRangeInclusive((String)"Latitude", (Double)latitude, (double)-90.0, (double)90.0);
        Require.inRangeInclusive((String)"Longitude", (Double)longitude, (double)-180.0, (double)180.0);
        this.map.put(LATITUDE, latitude);
        this.map.put(LONGITUDE, longitude);
        this.map.put(ACCURACY, 1.0);
    }

    public GeolocationCoordinates accuracy(double accuracy) {
        this.map.put(ACCURACY, Require.nonNegative((String)"Accuracy", (Double)accuracy));
        return this;
    }

    public GeolocationCoordinates altitude(@Nullable Double altitude) {
        if (altitude != null) {
            this.map.put(ALTITUDE, altitude);
        }
        return this;
    }

    public GeolocationCoordinates altitudeAccuracy(@Nullable Double altitudeAccuracy) {
        if (altitudeAccuracy != null) {
            if (!this.map.containsKey(ALTITUDE)) {
                throw new IllegalArgumentException("altitudeAccuracy cannot be set without altitude");
            }
            this.map.put(ALTITUDE_ACCURACY, Require.nonNegative((String)"Altitude accuracy", (Double)altitudeAccuracy));
        }
        return this;
    }

    public GeolocationCoordinates heading(@Nullable Double heading) {
        if (heading != null) {
            this.map.put(HEADING, Require.inRangeInclusive((String)"Heading", (Double)heading, (double)0.0, (double)360.0));
        }
        return this;
    }

    public GeolocationCoordinates speed(@Nullable Double speed) {
        if (speed != null) {
            this.map.put(SPEED, Require.nonNegative((String)"Speed", (Double)speed));
        }
        return this;
    }

    public double getLatitude() {
        return (Double)this.map.get(LATITUDE);
    }

    public double getLongitude() {
        return (Double)this.map.get(LONGITUDE);
    }

    public double getAccuracy() {
        return (Double)this.map.get(ACCURACY);
    }

    public @Nullable Double getAltitude() {
        return (Double)this.map.get(ALTITUDE);
    }

    public @Nullable Double getAltitudeAccuracy() {
        return (Double)this.map.get(ALTITUDE_ACCURACY);
    }

    public @Nullable Double getHeading() {
        return (Double)this.map.get(HEADING);
    }

    public @Nullable Double getSpeed() {
        return (Double)this.map.get(SPEED);
    }

    public Map<String, Object> toMap() {
        return Map.copyOf(this.map);
    }
}

