/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.Map;
import org.openqa.selenium.bidi.browsingcontext.DownloadCanceled;
import org.openqa.selenium.bidi.browsingcontext.DownloadCompleted;
import org.openqa.selenium.bidi.browsingcontext.NavigationInfo;
import org.openqa.selenium.json.JsonInput;

public class DownloadEnded {
    private static final String CANCELED = "canceled";
    private static final String COMPLETE = "complete";
    private final NavigationInfo downloadParams;

    public DownloadEnded(NavigationInfo downloadParams) {
        this.downloadParams = downloadParams;
    }

    public static DownloadEnded fromJson(JsonInput input) {
        String status;
        Map jsonMap = input.readMap();
        switch (status = (String)jsonMap.get("status")) {
            case "canceled": {
                return new DownloadEnded(DownloadCanceled.fromJson(jsonMap));
            }
            case "complete": {
                return new DownloadEnded(DownloadCompleted.fromJson(jsonMap));
            }
        }
        throw new IllegalArgumentException(String.format("status must be either '%s' or '%s', but got: %s", CANCELED, COMPLETE, status));
    }

    public NavigationInfo getDownloadParams() {
        return this.downloadParams;
    }

    public boolean isCanceled() {
        return this.downloadParams instanceof DownloadCanceled;
    }

    public boolean isCompleted() {
        return this.downloadParams instanceof DownloadCompleted;
    }
}

