/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class Command<X> {
    private final String method;
    private final Map<String, @Nullable Object> params;
    private final Function<JsonInput, X> mapper;
    private final boolean sendsResponse;

    public Command(String method, Map<String, @Nullable Object> params) {
        this(method, params, (Type)((Object)Object.class));
    }

    public Command(String method, Map<String, @Nullable Object> params, Type typeOfX) {
        this(method, params, (JsonInput input) -> input.readNonNull((Type)Require.nonNull((String)"Type to convert to", (Object)typeOfX)));
    }

    public Command(String method, Map<String, @Nullable Object> params, Function<JsonInput, X> mapper) {
        this(method, params, mapper, true);
    }

    public Command(String method, Map<String, @Nullable Object> params, Function<JsonInput, X> mapper, boolean sendsResponse) {
        this.method = (String)Require.nonNull((String)"Method name", (Object)method);
        this.params = Collections.unmodifiableMap(new HashMap((Map)Require.nonNull((String)"Command parameters", params)));
        this.mapper = (Function)Require.nonNull((String)"Mapper for result", mapper);
        this.sendsResponse = sendsResponse;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, @Nullable Object> getParams() {
        return this.params;
    }

    public boolean getSendsResponse() {
        return this.sendsResponse;
    }

    Function<JsonInput, X> getMapper() {
        return this.mapper;
    }
}

