/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;

@AutoService(value={SdkTracerProviderConfigurer.class})
public class SeleniumSpanExporter
implements SdkTracerProviderConfigurer {
    private static final Logger LOG = Logger.getLogger(SeleniumSpanExporter.class.getName());
    private final boolean httpLogs = OpenTelemetryTracer.getHttpLogs();

    public void configure(SdkTracerProviderBuilder tracerProvider, ConfigProperties configProperties) {
        tracerProvider.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)new SpanExporter(){

            public CompletableResultCode export(Collection<SpanData> spans) {
                spans.forEach(span -> {
                    LOG.fine(String.valueOf(span));
                    String traceId = span.getTraceId();
                    List eventList = span.getEvents();
                    Level logLevel = SeleniumSpanExporter.this.getLogLevel(span);
                    eventList.forEach(event -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("eventTime", event.getEpochNanos());
                        map.put("traceId", traceId);
                        map.put("eventName", event.getName());
                        Attributes attributes = event.getAttributes();
                        map.put("attributes", attributes.asMap());
                        String jsonString = SeleniumSpanExporter.getJsonString(map);
                        LOG.log(logLevel, jsonString);
                    });
                });
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode flush() {
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode shutdown() {
                return CompletableResultCode.ofSuccess();
            }
        }));
    }

    private static String getJsonString(Map<String, Object> map) {
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = new Json().newOutput((Appendable)text).setPrettyPrint(false);){
            json.write(map);
            text.append('\n');
        }
        return text.toString();
    }

    private Level getLogLevel(SpanData span) {
        Level level = Level.FINE;
        Optional<String> kind = Optional.ofNullable((String)span.getAttributes().get(io.opentelemetry.api.common.AttributeKey.stringKey((String)AttributeKey.SPAN_KIND.getKey())));
        if (span.getStatus().getStatusCode() == StatusCode.ERROR) {
            level = Level.WARNING;
        } else if (this.httpLogs && kind.isPresent()) {
            String kindValue = kind.get();
            if (Span.Kind.SERVER.name().equalsIgnoreCase(kindValue) || Span.Kind.CLIENT.name().equalsIgnoreCase(kindValue)) {
                level = Level.INFO;
            }
        }
        return level;
    }
}

