/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import com.google.auto.service.AutoService;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Realm;
import org.asynchttpclient.config.AsyncHttpClientConfigDefaults;
import org.openqa.selenium.Credentials;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClientName;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.netty.NettyDomainSocketClient;
import org.openqa.selenium.remote.http.netty.NettyHttpHandler;
import org.openqa.selenium.remote.http.netty.NettyWebSocket;

public class NettyClient
implements HttpClient {
    private static final Timer TIMER;
    private static final AsyncHttpClient client;
    private final ClientConfig config;
    private final HttpHandler handler;
    private final BiFunction<HttpRequest, WebSocket.Listener, WebSocket> toWebSocket;

    private NettyClient(ClientConfig config) {
        this.config = (ClientConfig)Require.nonNull((String)"HTTP client config", (Object)config);
        this.handler = new NettyHttpHandler(config, client).with(config.filter());
        this.toWebSocket = NettyWebSocket.create(config, client);
    }

    static int toClampedInt(long value) {
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, value));
    }

    private static AsyncHttpClient createHttpClient(ClientConfig config) {
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setThreadFactory((ThreadFactory)new DefaultThreadFactory("AsyncHttpClient", true)).setUseInsecureTrustManager(true).setAggregateWebSocketFrameFragments(true).setWebSocketMaxBufferSize(Integer.MAX_VALUE).setWebSocketMaxFrameSize(Integer.MAX_VALUE).setNettyTimer(TIMER).setRequestTimeout(NettyClient.toClampedInt(config.readTimeout().toMillis())).setConnectTimeout(NettyClient.toClampedInt(config.connectionTimeout().toMillis())).setReadTimeout(NettyClient.toClampedInt(config.readTimeout().toMillis())).setUseProxyProperties(true).setUseProxySelector(true);
        if (config.credentials() != null) {
            Credentials credentials = config.credentials();
            if (!(credentials instanceof UsernameAndPassword)) {
                throw new IllegalArgumentException("Credentials must be a username and password");
            }
            UsernameAndPassword uap = (UsernameAndPassword)credentials;
            builder.setRealm(new Realm.Builder(uap.username(), uap.password()).setUsePreemptiveAuth(true));
        }
        return Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)builder);
    }

    public HttpResponse execute(HttpRequest request) {
        return this.handler.execute(request);
    }

    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        Require.nonNull((String)"Request to send", (Object)request);
        Require.nonNull((String)"WebSocket listener", (Object)listener);
        return this.toWebSocket.apply(request, listener);
    }

    public HttpClient with(Filter filter) {
        Require.nonNull((String)"Filter", (Object)filter);
        return new NettyClient(this.config.withFilter(filter));
    }

    public void close() {
    }

    static {
        client = NettyClient.createHttpClient(ClientConfig.defaultConfig());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory("netty-client-timer", true);
        TIMER = new HashedWheelTimer((ThreadFactory)threadFactory, (long)AsyncHttpClientConfigDefaults.defaultHashedWheelTimerTickDuration(), TimeUnit.MILLISECONDS, AsyncHttpClientConfigDefaults.defaultHashedWheelTimerSize());
    }

    @HttpClientName(value="netty")
    @AutoService(value={HttpClient.Factory.class})
    public static class Factory
    implements HttpClient.Factory {
        public HttpClient createClient(ClientConfig config) {
            Require.nonNull((String)"Client config", (Object)config);
            if (config.baseUri() != null && "unix".equals(config.baseUri().getScheme())) {
                return new NettyDomainSocketClient(config);
            }
            return new NettyClient(config);
        }
    }
}

