/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.IOException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

public class TracedCommandExecutor
implements CommandExecutor {
    private final CommandExecutor delegate;
    private final Tracer tracer;

    public TracedCommandExecutor(CommandExecutor delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    @Override
    public Response execute(Command command) throws IOException {
        try (Span commandSpan = this.tracer.getCurrentContext().createSpan("command");){
            commandSpan.setAttribute("command", command.toString());
            Response response = this.delegate.execute(command);
            return response;
        }
    }
}

