/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.SpanId;
import io.opentelemetry.trace.TraceFlags;
import io.opentelemetry.trace.TraceId;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.Tracestate;
import java.util.Objects;
import java.util.logging.Logger;
import org.openqa.selenium.remote.http.HttpRequest;

public class HttpTracing {
    private static final Logger LOG = Logger.getLogger(HttpTracing.class.getName());
    private static final SpanContext NO_OP_CONTEXT = SpanContext.create((TraceId)TraceId.getInvalid(), (SpanId)SpanId.getInvalid(), (TraceFlags)TraceFlags.getDefault(), (Tracestate)Tracestate.getDefault());

    private HttpTracing() {
    }

    private static SpanContext extract(Tracer tracer, HttpRequest request) {
        Objects.requireNonNull(tracer, "Tracer to use must be set.");
        Objects.requireNonNull(request, "Request must be set.");
        try {
            return (SpanContext)tracer.getHttpTextFormat().extract((Object)request, (req, key) -> req.getHeader(key));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return NO_OP_CONTEXT;
        }
    }

    public static Span.Builder newSpanAsChildOf(Tracer tracer, HttpRequest request, String name) {
        Objects.requireNonNull(tracer, "Tracer to use must be set.");
        Objects.requireNonNull(request, "Request must be set.");
        Objects.requireNonNull(name, "Name to use must be set.");
        SpanContext parent = HttpTracing.extract(tracer, request);
        Span.Builder builder = tracer.spanBuilder(name);
        if (parent != null) {
            builder.setParent(parent);
        } else {
            builder.setNoParent();
        }
        return builder;
    }

    public static void inject(Tracer tracer, Span span, HttpRequest request) {
        if (span == null) {
            return;
        }
        Objects.requireNonNull(tracer, "Tracer to use must be set.");
        Objects.requireNonNull(request, "Request must be set.");
        StackTraceElement caller = Thread.currentThread().getStackTrace()[2];
        LOG.fine(String.format("Injecting %s into %s at %s:%d", request, span, caller.getClassName(), caller.getLineNumber()));
        span.setAttribute("http.method", request.getMethod().toString());
        span.setAttribute("http.url", request.getUri());
        tracer.getHttpTextFormat().inject((Object)span.getContext(), (Object)request, (req, key, value) -> req.setHeader(key, value));
    }
}

