/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.okhttp;

import java.util.Objects;
import java.util.function.BiFunction;
import okhttp3.ConnectionPool;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.WebSocket;
import org.openqa.selenium.remote.http.okhttp.OkHandler;
import org.openqa.selenium.remote.http.okhttp.OkHttpWebSocket;

public class OkHttpClient
implements HttpClient {
    private final HttpHandler handler;
    private BiFunction<HttpRequest, WebSocket.Listener, WebSocket> toWebSocket;

    private OkHttpClient(HttpHandler handler, BiFunction<HttpRequest, WebSocket.Listener, WebSocket> toWebSocket) {
        this.handler = Objects.requireNonNull(handler);
        this.toWebSocket = Objects.requireNonNull(toWebSocket);
    }

    public HttpResponse execute(HttpRequest request) {
        return this.handler.execute(request);
    }

    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        Objects.requireNonNull(request, "Request to send must be set.");
        Objects.requireNonNull(listener, "WebSocket listener must be set.");
        return this.toWebSocket.apply(request, listener);
    }

    public HttpClient with(Filter filter) {
        Objects.requireNonNull(filter, "Filter to use must be set.");
        return new OkHttpClient(this.handler.with(filter), this.toWebSocket);
    }

    public static class Factory
    implements HttpClient.Factory {
        private final ConnectionPool pool = new ConnectionPool();

        public HttpClient createClient(ClientConfig config) {
            Objects.requireNonNull(config, "Client config to use must be set.");
            return new OkHttpClient(new OkHandler(config).with(config.filter()), OkHttpWebSocket.create(config));
        }

        public void cleanupIdleClients() {
            this.pool.evictAll();
        }
    }
}

