/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.UnixChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.RemoteCall;
import org.openqa.selenium.remote.http.WebSocket;

class NettyDomainSocketClient
extends RemoteCall
implements HttpClient {
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends Channel> channelClazz;
    private final String path;
    private final HttpHandler handler;

    public NettyDomainSocketClient(ClientConfig config) {
        super(config);
        URI uri = config.baseUri();
        Preconditions.checkArgument((boolean)"unix".equals(uri.getScheme()), (Object)"URI scheme must be `unix`");
        if (Epoll.isAvailable()) {
            this.eventLoopGroup = new EpollEventLoopGroup();
            this.channelClazz = EpollDomainSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            this.eventLoopGroup = new KQueueEventLoopGroup();
            this.channelClazz = KQueueDomainSocketChannel.class;
        } else {
            throw new IllegalStateException("No native library for unix domain sockets is available");
        }
        this.path = uri.getPath();
        this.handler = config.filter().andFinally((HttpHandler)this);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Objects.requireNonNull(req, "Request to send must be set.");
        AtomicReference<HttpResponse> outRef = new AtomicReference<HttpResponse>();
        CountDownLatch latch = new CountDownLatch(1);
        Channel channel = this.createChannel(outRef, latch);
        StringBuilder uri = new StringBuilder(req.getUri());
        ArrayList queryPairs = new ArrayList();
        req.getQueryParameterNames().forEach(name -> req.getQueryParameters(name).forEach(value -> {
            try {
                queryPairs.add(URLEncoder.encode(name, StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }));
        if (!queryPairs.isEmpty()) {
            uri.append("?");
            Joiner.on((char)'&').appendTo(uri, queryPairs);
        }
        byte[] bytes = Contents.bytes((Supplier)req.getContent());
        DefaultFullHttpRequest fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)req.getMethod().toString()), uri.toString(), Unpooled.wrappedBuffer((byte[])bytes));
        req.getHeaderNames().forEach(name -> req.getHeaders(name).forEach(value -> fullRequest.headers().add(name, value)));
        fullRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        fullRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        fullRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        ChannelFuture future = channel.writeAndFlush((Object)fullRequest);
        try {
            future.get();
            channel.closeFuture().sync();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedIOException(new IOException(e));
        }
        try {
            latch.await(this.getConfig().readTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return outRef.get();
    }

    public WebSocket openSocket(HttpRequest request, WebSocket.Listener listener) {
        throw new UnsupportedOperationException("openSocket");
    }

    private Channel createChannel(final AtomicReference<HttpResponse> outRef, final CountDownLatch latch) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(this.channelClazz)).handler((ChannelHandler)new ChannelInitializer<UnixChannel>(){

            public void initChannel(UnixChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpContentDecompressor()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpResponse>(){

                    public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
                        HttpResponse res = new HttpResponse().setStatus(msg.status().code());
                        msg.headers().forEach(entry -> res.addHeader((String)entry.getKey(), (String)entry.getValue()));
                        try (ByteBufInputStream is = new ByteBufInputStream(msg.content());
                             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                            ByteStreams.copy((InputStream)is, (OutputStream)bos);
                            res.setContent(Contents.bytes((byte[])bos.toByteArray()));
                            outRef.set(res);
                            latch.countDown();
                        }
                        catch (IOException e) {
                            outRef.set((HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.string((CharSequence)Throwables.getStackTraceAsString((Throwable)e), (Charset)StandardCharsets.UTF_8)));
                            latch.countDown();
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        outRef.set((HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.string((CharSequence)Throwables.getStackTraceAsString((Throwable)cause), (Charset)StandardCharsets.UTF_8)));
                        latch.countDown();
                    }
                }});
            }
        });
        try {
            return bootstrap.connect((SocketAddress)new DomainSocketAddress(this.path)).sync().channel();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

