/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.UrlTemplate;

public abstract class Route
implements HttpHandler,
Predicate<HttpRequest> {
    public HttpHandler fallbackTo(Supplier<HttpHandler> handler) {
        Objects.requireNonNull(handler, "Handler to use must be set.");
        return req -> {
            if (this.test(req)) {
                return (HttpResponse)this.apply(req);
            }
            return (HttpResponse)((HttpHandler)Objects.requireNonNull(handler.get(), "Handler to use must be set.")).apply(req);
        };
    }

    public static TemplatizedRouteConfig delete(String template) {
        Objects.requireNonNull(template, "URL template to use must be set.");
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.DELETE).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig get(String template) {
        Objects.requireNonNull(template, "URL template to use must be set.");
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.GET).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig post(String template) {
        Objects.requireNonNull(template, "URL template to use must be set.");
        UrlTemplate urlTemplate = new UrlTemplate(template);
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.POST).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static NestedRouteConfig prefix(String prefix) {
        Objects.requireNonNull(prefix, "Prefix to use must be set.");
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (Object)"Prefix to use must not be of 0 length");
        return new NestedRouteConfig(prefix);
    }

    public static Route combine(Route first, Route ... others) {
        Objects.requireNonNull(first, "At least one route must be set.");
        return new CombinedRoute(Stream.concat(Stream.of(first), Stream.of(others)));
    }

    public static Route combine(Iterable<Route> routes) {
        Objects.requireNonNull(routes, "At least one route must be set.");
        return new CombinedRoute(StreamSupport.stream(routes.spliterator(), false));
    }

    private static class CombinedRoute
    extends Route {
        private final List<Route> allRoutes;

        public CombinedRoute(Stream<Route> routes) {
            this.allRoutes = ((ImmutableList)routes.collect(ImmutableList.toImmutableList())).reverse();
            Preconditions.checkArgument((!this.allRoutes.isEmpty() ? 1 : 0) != 0, (Object)"At least one route must be specified.");
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.allRoutes.stream().anyMatch(route -> route.test(request));
        }

        @Override
        public HttpResponse apply(HttpRequest request) {
            return (HttpResponse)this.allRoutes.stream().filter(route -> route.test(request)).findFirst().map(route -> route).orElse(req -> (HttpResponse)new HttpResponse().setStatus(404).setContent(Contents.utf8String("No handler found for " + req))).apply(request);
        }
    }

    private static class NestedRoute
    extends Route {
        private final String prefix;
        private final Route route;

        private NestedRoute(String prefix, Route route) {
            this.prefix = Objects.requireNonNull(prefix, "Prefix must be set.");
            this.route = Objects.requireNonNull(route, "Target for requests must be set.");
        }

        @Override
        public boolean test(HttpRequest request) {
            return request.getUri().startsWith(this.prefix) && this.route.test(this.transform(request));
        }

        @Override
        public HttpResponse apply(HttpRequest request) {
            return (HttpResponse)this.route.apply(this.transform(request));
        }

        private HttpRequest transform(HttpRequest request) {
            String unprefixed = request.getUri().startsWith(this.prefix) ? request.getUri().substring(this.prefix.length()) : request.getUri();
            HttpRequest toForward = new HttpRequest(request.getMethod(), unprefixed);
            request.getHeaderNames().forEach(name -> {
                if (name == null) {
                    return;
                }
                request.getHeaders((String)name).forEach(value -> {
                    HttpRequest cfr_ignored_0 = (HttpRequest)toForward.addHeader((String)name, (String)value);
                });
            });
            request.getAttributeNames().forEach(attr -> {
                HttpRequest cfr_ignored_0 = (HttpRequest)toForward.setAttribute((String)attr, request.getAttribute((String)attr));
            });
            toForward.setContent(request.getContent());
            return toForward;
        }
    }

    public static class NestedRouteConfig {
        private final String prefix;

        public NestedRouteConfig(String prefix) {
            this.prefix = Objects.requireNonNull(prefix, "Prefix must be set.");
        }

        public Route to(Route route) {
            Objects.requireNonNull(route, "Target for requests must be set.");
            return new NestedRoute(this.prefix, route);
        }
    }

    private static class MatchesTemplate
    implements Predicate<HttpRequest> {
        private final UrlTemplate template;

        private MatchesTemplate(UrlTemplate template) {
            this.template = Objects.requireNonNull(template, "URL template to test must be set.");
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.template.match(request.getUri()) != null;
        }
    }

    private static class MatchesHttpMethod
    implements Predicate<HttpRequest> {
        private final HttpMethod method;

        private MatchesHttpMethod(HttpMethod method) {
            this.method = Objects.requireNonNull(method, "HTTP method to test must be set.");
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.method == request.getMethod();
        }
    }

    private static class TemplatizedRoute
    extends Route {
        private final UrlTemplate template;
        private final Predicate<HttpRequest> predicate;
        private final Function<Map<String, String>, HttpHandler> handlerFunction;

        private TemplatizedRoute(UrlTemplate template, Predicate<HttpRequest> predicate, Function<Map<String, String>, HttpHandler> handlerFunction) {
            this.template = Objects.requireNonNull(template);
            this.predicate = Objects.requireNonNull(predicate);
            this.handlerFunction = Objects.requireNonNull(handlerFunction);
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.predicate.test(request);
        }

        @Override
        public HttpResponse apply(HttpRequest request) {
            UrlTemplate.Match match = this.template.match(request.getUri());
            HttpHandler handler = this.handlerFunction.apply((Map<String, String>)(match == null ? ImmutableMap.of() : match.getParameters()));
            if (handler == null) {
                return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.utf8String("Unable to find handler for " + request));
            }
            return (HttpResponse)handler.apply(request);
        }
    }

    public static class TemplatizedRouteConfig {
        private final Predicate<HttpRequest> predicate;
        private final UrlTemplate template;

        private TemplatizedRouteConfig(Predicate<HttpRequest> predicate, UrlTemplate template) {
            this.predicate = Objects.requireNonNull(predicate);
            this.template = Objects.requireNonNull(template);
        }

        public Route to(Supplier<HttpHandler> handler) {
            Objects.requireNonNull(handler, "Handler supplier must be set.");
            return this.to((Map<String, String> params) -> (HttpHandler)handler.get());
        }

        public Route to(Function<Map<String, String>, HttpHandler> handlerFunc) {
            Objects.requireNonNull(handlerFunc, "Handler creator must be set.");
            return new TemplatizedRoute(this.template, this.predicate, handlerFunc);
        }
    }
}

