/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.SessionId;

public class Command {
    private final SessionId sessionId;
    private final CommandPayload payload;

    public Command(SessionId sessionId, String name) {
        this(sessionId, name, new HashMap());
    }

    public Command(SessionId sessionId, String name, Map<String, ?> parameters) {
        this(sessionId, new CommandPayload(name, parameters));
    }

    public Command(SessionId sessionId, CommandPayload payload) {
        this.sessionId = sessionId;
        this.payload = payload;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.payload.getName();
    }

    public Map<String, ?> getParameters() {
        return this.payload.getParameters();
    }

    public String toString() {
        return "[" + this.sessionId + ", " + this.getName() + " " + this.getParameters() + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Command)) {
            return false;
        }
        Command that = (Command)o;
        return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getParameters(), that.getParameters());
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.getName(), this.getParameters());
    }
}

