/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.security.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.SecurityState;
import org.openqa.selenium.devtools.security.model.SecurityStateExplanation;
import org.openqa.selenium.json.JsonInput;

public class SecurityStateChanged {
    private SecurityState securityState;
    private boolean schemeIsCryptographic;
    private List<SecurityStateExplanation> securityStateExplanations;
    private String summary;

    private SecurityStateChanged(SecurityState securityState, boolean schemeIsCryptographic, List<SecurityStateExplanation> securityStateExplanations, String summary) {
        this.securityState = Objects.requireNonNull(securityState, "'securityState' is required for SecurityStateChanged");
        this.schemeIsCryptographic = schemeIsCryptographic;
        this.securityStateExplanations = securityStateExplanations;
        this.summary = summary;
    }

    private static SecurityStateChanged fromJson(JsonInput input) {
        SecurityState securityState = SecurityState.valueOf(input.nextString());
        boolean schemeIsCryptographic = false;
        List securityStateExplanations = null;
        String summary = null;
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "schemeIsCryptographic": {
                    schemeIsCryptographic = input.nextBoolean();
                    continue block10;
                }
                case "securityStateExplanations": {
                    securityStateExplanations = (List)input.read(new TypeToken<List<SecurityStateExplanation>>(){}.getType());
                    continue block10;
                }
                case "summary": {
                    summary = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        return new SecurityStateChanged(securityState, schemeIsCryptographic, securityStateExplanations, summary);
    }

    public SecurityState getSecurityState() {
        return this.securityState;
    }

    public boolean isSchemeIsCryptographic() {
        return this.schemeIsCryptographic;
    }

    public List<SecurityStateExplanation> getSecurityStateExplanations() {
        return this.securityStateExplanations;
    }

    public String getSummary() {
        return this.summary;
    }
}

