/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.profiler.model.TypeProfileEntry;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ScriptTypeProfile {
    private final String scriptId;
    private final String url;
    private final List<TypeProfileEntry> entries;

    public ScriptTypeProfile(String scriptId, String url, List<TypeProfileEntry> entries) {
        this.validateEntries(entries);
        Objects.requireNonNull(url, "url is require");
        Objects.requireNonNull(scriptId, "scriptId is require");
        this.scriptId = scriptId;
        this.url = url;
        this.entries = entries;
    }

    private static ScriptTypeProfile fromJson(JsonInput input) {
        String scriptId = input.nextString();
        String url = null;
        ArrayList entries = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block8;
                }
                case "entries": {
                    entries = new ArrayList();
                    input.beginArray();
                    while (input.hasNext()) {
                        entries.add(input.read((Type)((Object)ScriptTypeProfile.class)));
                    }
                    input.endArray();
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new ScriptTypeProfile(scriptId, url, entries);
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public List<TypeProfileEntry> getEntries() {
        return this.entries;
    }

    private void validateEntries(List<TypeProfileEntry> entries) {
        Objects.requireNonNull(entries, "entries are require");
        if (entries.isEmpty()) {
            throw new DevToolsException("entries are require");
        }
    }
}

