/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class WebSocketClosed {
    private final RequestId requestId;
    private final MonotonicTime timestamp;

    private WebSocketClosed(RequestId requestId, MonotonicTime timeStamp) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for WebSocketClosed");
        this.timestamp = Objects.requireNonNull(timeStamp, "'timestamp' is required for WebSocketClosed");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    private static WebSocketClosed fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        MonotonicTime timestamp = null;
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block6;
                }
            }
            input.skipValue();
        }
        return new WebSocketClosed(requestId, timestamp);
    }
}

