/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.http.AbstractHttpCommandCodec;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;

public class W3CHttpCommandCodec
extends AbstractHttpCommandCodec {
    public W3CHttpCommandCodec() {
        this.alias("getElementAttribute", "executeScript");
        this.alias("getElementLocation", "getElementRect");
        this.alias("getElementLocationOnceScrolledIntoView", "executeScript");
        this.alias("getElementSize", "getElementRect");
        this.alias("isElementDisplayed", "executeScript");
        this.alias("submitElement", "executeScript");
        this.defineCommand("executeScript", W3CHttpCommandCodec.post("/session/:sessionId/execute/sync"));
        this.defineCommand("executeAsyncScript", W3CHttpCommandCodec.post("/session/:sessionId/execute/async"));
        this.alias("getPageSource", "executeScript");
        this.defineCommand("maximizeCurrentWindow", W3CHttpCommandCodec.post("/session/:sessionId/window/maximize"));
        this.alias("getWindowPosition", "executeScript");
        this.alias("setWindowPosition", "executeScript");
        this.defineCommand("getCurrentWindowSize", W3CHttpCommandCodec.get("/session/:sessionId/window/size"));
        this.defineCommand("setCurrentWindowSize", W3CHttpCommandCodec.post("/session/:sessionId/window/size"));
        this.defineCommand("getCurrentWindowHandle", W3CHttpCommandCodec.get("/session/:sessionId/window"));
        this.defineCommand("getWindowHandles", W3CHttpCommandCodec.get("/session/:sessionId/window/handles"));
        this.defineCommand("acceptAlert", W3CHttpCommandCodec.post("/session/:sessionId/alert/accept"));
        this.defineCommand("dismissAlert", W3CHttpCommandCodec.post("/session/:sessionId/alert/dismiss"));
        this.defineCommand("getAlertText", W3CHttpCommandCodec.get("/session/:sessionId/alert/text"));
        this.defineCommand("setAlertValue", W3CHttpCommandCodec.post("/session/:sessionId/alert/text"));
    }

    @Override
    protected Map<String, ?> amendParameters(String name, Map<String, ?> parameters) {
        switch (name) {
            case "findChildElement": 
            case "findChildElements": 
            case "findElement": 
            case "findElements": {
                String using = (String)parameters.get("using");
                String value = (String)parameters.get("value");
                HashMap<String, Object> toReturn = new HashMap<String, Object>();
                toReturn.putAll(parameters);
                switch (using) {
                    case "class name": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "." + this.cssEscape(value));
                        break;
                    }
                    case "id": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "#" + this.cssEscape(value));
                        break;
                    }
                    case "link text": {
                        break;
                    }
                    case "name": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "*[name='" + value + "']");
                        break;
                    }
                    case "partial link text": {
                        break;
                    }
                    case "tag name": {
                        toReturn.put("using", "css selector");
                        toReturn.put("value", "#" + this.cssEscape(value));
                        break;
                    }
                }
                return toReturn;
            }
            case "getElementAttribute": {
                return this.executeAtom("getAttribute.js", this.asElement(parameters.get("id")), parameters.get("name"));
            }
            case "getElementLocationOnceScrolledIntoView": {
                return this.toScript("return arguments[0].getBoundingClientRect()", this.asElement(parameters.get("id")));
            }
            case "getPageSource": {
                return this.toScript("var source = document.documentElement.outerHTML; \nif (!source) { source = new XMLSerializer().serializeToString(document); }\nreturn source;", new Object[0]);
            }
            case "getWindowPosition": {
                return this.toScript("return {x: window.screenX, y: window.screenY}", new Object[0]);
            }
            case "isElementDisplayed": {
                return this.executeAtom("isDisplayed.js", this.asElement(parameters.get("id")));
            }
            case "setWindowPosition": {
                return this.toScript("window.screenX = arguments[0]; window.screenY = arguments[1]", parameters.get("x"), parameters.get("y"));
            }
            case "submitElement": {
                return this.toScript("var form = arguments[0];\nwhile (form.nodeName != \"FORM\" && form.parentNode) {\n  form = form.parentNode;\n}\nif (form == null) { throw Error('Unable to find containing form element'); }\nvar e = form.ownerDocument.createEvent('Event');\ne.initEvent('submit', true, true);\nif (form.dispatchEvent(e)) { form.submit() }\n", this.asElement(parameters.get("id")));
            }
        }
        return parameters;
    }

    private Map<String, ?> executeAtom(String atomFileName, Object ... args) {
        try {
            String scriptName = "/org/openqa/selenium/remote/" + atomFileName;
            URL url = this.getClass().getResource(scriptName);
            String rawFunction = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
            String script = String.format("return (%s).apply(null, arguments);", rawFunction);
            return this.toScript(script, args);
        }
        catch (IOException | NullPointerException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private Map<String, ?> toScript(String script, Object ... args) {
        script = script.replaceAll("\"", "\\\"");
        Iterable convertedArgs = Iterables.transform((Iterable)Lists.newArrayList((Object[])args), (Function)new WebElementToJsonConverter());
        return ImmutableMap.of((Object)"script", (Object)script, (Object)"args", (Object)Lists.newArrayList((Iterable)convertedArgs));
    }

    private Map<String, String> asElement(Object id) {
        return ImmutableMap.of((Object)"element-6066-11e4-a52e-4f735466cecf", (Object)((String)id));
    }

    private String cssEscape(String using) {
        if ((using = using.replaceAll("(['\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-\\/\\[\\]\\(\\)])", "\\\\$1")).length() > 0 && Character.isDigit(using.charAt(0))) {
            using = "\\" + Integer.toString(30 + Integer.parseInt(using.substring(0, 1))) + " " + using.substring(1);
        }
        return using;
    }
}

