/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DaemonExecutor;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.CircularOutputStream;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.os.OsProcess;
import org.openqa.selenium.os.ProcessUtils;
import org.openqa.selenium.os.WindowsUtils;

class UnixProcess
implements OsProcess {
    private static final Logger log = Logger.getLogger(UnixProcess.class.getName());
    private final CircularOutputStream inputOut = new CircularOutputStream(32768);
    private volatile String allInput;
    private final DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler();
    private final Executor executor = new DaemonExecutor();
    private volatile OutputStream drainTo;
    private SeleniumWatchDog executeWatchdog = new SeleniumWatchDog(-1L);
    private final CommandLine cl;
    private final Map<String, String> env = new ConcurrentHashMap<String, String>();

    public UnixProcess(String executable, String ... args) {
        String actualExe = (String)Preconditions.checkNotNull((Object)new ExecutableFinder().find(executable), (String)"Unable to find executable for: %s", (Object)executable);
        this.cl = new CommandLine(actualExe);
        this.cl.addArguments(args, false);
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Cannot have a null environment variable name!");
        }
        if (value == null) {
            throw new IllegalArgumentException("Cannot have a null value for environment variable " + name);
        }
        this.env.put(name, value);
    }

    @Override
    @VisibleForTesting
    public Map<String, String> getEnvironment() {
        return ImmutableMap.copyOf(this.env);
    }

    private Map<String, String> getMergedEnv() {
        HashMap newEnv = Maps.newHashMap(System.getenv());
        newEnv.putAll(this.env);
        return newEnv;
    }

    private ByteArrayInputStream getInputStream() {
        return this.allInput != null ? new ByteArrayInputStream(this.allInput.getBytes()) : null;
    }

    @Override
    public void executeAsync() {
        try {
            OutputStream outputStream = this.getOutputStream();
            this.executeWatchdog.reset();
            this.executor.setWatchdog((ExecuteWatchdog)this.executeWatchdog);
            this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(outputStream, outputStream, (InputStream)this.getInputStream()));
            this.executor.execute(this.cl, this.getMergedEnv(), (ExecuteResultHandler)this.handler);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private OutputStream getOutputStream() {
        return this.drainTo == null ? this.inputOut : new MultioutputStream(this.inputOut, this.drainTo);
    }

    @Override
    public int destroy() {
        SeleniumWatchDog watchdog = this.executeWatchdog;
        watchdog.waitForProcessStarted();
        if (!WindowsUtils.thisIsWindows()) {
            watchdog.destroyProcess();
            watchdog.waitForTerminationAfterDestroy(2, TimeUnit.SECONDS);
            if (!this.isRunning()) {
                return this.getExitCode();
            }
            log.info("Command failed to close cleanly. Destroying forcefully (v2). " + this);
        }
        watchdog.destroyHarder();
        watchdog.waitForTerminationAfterDestroy(1, TimeUnit.SECONDS);
        if (!this.isRunning()) {
            return this.getExitCode();
        }
        log.severe(String.format("Unable to kill process with PID %s", watchdog.getPID()));
        int exitCode = -1;
        this.executor.setExitValue(exitCode);
        return exitCode;
    }

    @Override
    public void waitFor() throws InterruptedException {
        this.handler.waitFor();
    }

    @Override
    public void waitFor(long timeout) throws InterruptedException {
        long until = System.currentTimeMillis() + timeout;
        boolean timedOut = true;
        while (System.currentTimeMillis() < until) {
            if (this.handler.hasResult()) {
                timedOut = false;
                break;
            }
            Thread.sleep(50L);
        }
        if (timedOut) {
            throw new InterruptedException(String.format("Process timed out after waiting for %d ms.", timeout));
        }
    }

    @Override
    public boolean isRunning() {
        return !this.handler.hasResult();
    }

    @Override
    public int getExitCode() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot get exit code before executing command line: " + this.cl);
        }
        return this.handler.getExitValue();
    }

    @Override
    public void checkForError() {
        if (this.handler.getException() != null) {
            log.severe(this.handler.getException().toString());
        }
    }

    @Override
    public String getStdOut() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot get output before executing command line: " + this.cl);
        }
        return this.inputOut.toString();
    }

    @Override
    public void setInput(String allInput) {
        this.allInput = allInput;
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        this.executor.setWorkingDirectory(workingDirectory);
    }

    public String toString() {
        return this.cl.toString() + "[ " + this.env + "]";
    }

    @Override
    public void copyOutputTo(OutputStream out) {
        this.drainTo = out;
    }

    class MultioutputStream
    extends OutputStream {
        private final OutputStream mandatory;
        private final OutputStream optional;

        MultioutputStream(OutputStream mandatory, OutputStream optional) {
            this.mandatory = mandatory;
            this.optional = optional;
        }

        @Override
        public void write(int b) throws IOException {
            this.mandatory.write(b);
            if (this.optional != null) {
                this.optional.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            this.mandatory.flush();
            if (this.optional != null) {
                this.optional.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.mandatory.close();
            if (this.optional != null) {
                this.optional.close();
            }
        }
    }

    class SeleniumWatchDog
    extends ExecuteWatchdog {
        private volatile Process process;
        private volatile boolean starting;

        SeleniumWatchDog(long timeout) {
            super(timeout);
            this.starting = true;
        }

        public synchronized void start(Process process) {
            this.process = process;
            this.starting = false;
            super.start(process);
        }

        public void reset() {
            this.starting = true;
        }

        private String getPID() {
            return String.valueOf(ProcessUtils.getProcessId(this.process));
        }

        private void waitForProcessStarted() {
            while (this.starting) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void waitForTerminationAfterDestroy(int duration, TimeUnit unit) {
            long end = System.currentTimeMillis() + unit.toMillis(duration);
            while (UnixProcess.this.isRunning() && System.currentTimeMillis() < end) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }

        private void destroyHarder() {
            ProcessUtils.killProcess(this.process);
        }
    }
}

