/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteMouse;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

public class RemoteWebElement
implements WebElement,
FindsByLinkText,
FindsById,
FindsByName,
FindsByTagName,
FindsByClassName,
FindsByCssSelector,
FindsByXPath,
WrapsDriver,
Locatable {
    private String foundBy;
    protected String id;
    protected RemoteWebDriver parent;
    protected RemoteMouse mouse;
    protected FileDetector fileDetector;

    protected void setFoundBy(SearchContext foundFrom, String locator, String term) {
        this.foundBy = String.format("[%s] -> %s: %s", foundFrom, locator, term);
    }

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
        this.mouse = (RemoteMouse)parent.getMouse();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFileDetector(FileDetector detector) {
        this.fileDetector = detector;
    }

    public void click() {
        this.execute("clickElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public void submit() {
        this.execute("submitElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public void sendKeys(CharSequence ... keysToSend) {
        File localFile = this.fileDetector.getLocalFile(keysToSend);
        if (localFile == null) {
            this.execute("sendKeysToElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"value", (Object)keysToSend));
            return;
        }
        String remotePath = this.upload(localFile);
        CharSequence[] keys = new CharSequence[]{remotePath};
        this.execute("sendKeysToElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"value", (Object)keys));
    }

    private String upload(File localFile) {
        if (!localFile.isFile()) {
            throw new WebDriverException("You may only upload files: " + localFile);
        }
        try {
            String zip = new Zip().zipFile(localFile.getParentFile(), localFile);
            Response response = this.execute("uploadFile", (Map<String, ?>)ImmutableMap.of((Object)"file", (Object)zip));
            return (String)response.getValue();
        }
        catch (IOException e) {
            throw new WebDriverException("Cannot upload " + localFile, (Throwable)e);
        }
    }

    public void clear() {
        this.execute("clearElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
    }

    public String getTagName() {
        return (String)this.execute("getElementTagName", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public String getAttribute(String name) {
        Object value = this.execute("getElementAttribute", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"name", (Object)name)).getValue();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public boolean isSelected() {
        return (Boolean)this.execute("isElementSelected", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public boolean isEnabled() {
        return (Boolean)this.execute("isElementEnabled", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id)).getValue();
    }

    public String getText() {
        Response response = this.execute("getElementText", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        return (String)response.getValue();
    }

    public String getCssValue(String propertyName) {
        Response response = this.execute("getElementValueOfCssProperty", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"propertyName", (Object)propertyName));
        return (String)response.getValue();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    protected WebElement findElement(String using, String value) {
        Response response = this.execute("findChildElement", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)using, (Object)"value", (Object)value));
        WebElement element = (WebElement)response.getValue();
        this.parent.setFoundBy((SearchContext)this, element, using, value);
        return element;
    }

    protected List<WebElement> findElements(String using, String value) {
        Response response = this.execute("findChildElements", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"using", (Object)using, (Object)"value", (Object)value));
        List allElements = (List)response.getValue();
        for (WebElement element : allElements) {
            this.parent.setFoundBy((SearchContext)this, element, using, value);
        }
        return allElements;
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByClassName(String using) {
        return this.findElement("class name", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        return this.findElements("class name", using);
    }

    public WebElement findElementByCssSelector(String using) {
        return this.findElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        return this.findElements("css selector", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    protected Response execute(String command, Map<String, ?> parameters) {
        return this.parent.execute(command, parameters);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        while (other instanceof WrapsElement) {
            other = ((WrapsElement)other).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        RemoteWebElement otherRemoteWebElement = (RemoteWebElement)other;
        if (this.id.equals(otherRemoteWebElement.id)) {
            return true;
        }
        Response response = this.execute("elementEquals", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id, (Object)"other", (Object)otherRemoteWebElement.id));
        Object value = response.getValue();
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    public boolean isDisplayed() {
        Response response = this.execute("isElementDisplayed", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        return (Boolean)response.getValue();
    }

    public Point getLocation() {
        Response response = this.execute("getElementLocation", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawPoint = (Map)response.getValue();
        int x = ((Number)rawPoint.get("x")).intValue();
        int y = ((Number)rawPoint.get("y")).intValue();
        return new Point(x, y);
    }

    public Dimension getSize() {
        Response response = this.execute("getElementSize", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.id));
        Map rawSize = (Map)response.getValue();
        int width = ((Number)rawSize.get("width")).intValue();
        int height = ((Number)rawSize.get("height")).intValue();
        return new Dimension(width, height);
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        Response response = this.execute("getElementLocationOnceScrolledIntoView", (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)this.getId()));
        Map mapped = (Map)response.getValue();
        return new Point(((Number)mapped.get("x")).intValue(), ((Number)mapped.get("y")).intValue());
    }

    public Coordinates getCoordinates() {
        return new Coordinates(){

            public Point getLocationOnScreen() {
                return RemoteWebElement.this.getLocationOnScreenOnceScrolledIntoView();
            }

            public Point getLocationInViewPort() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Point getLocationInDOM() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public Object getAuxiliary() {
                return RemoteWebElement.this.getId();
            }
        };
    }

    public String toString() {
        if (this.foundBy == null) {
            return String.format("[%s -> unknown locator]", super.toString());
        }
        return String.format("[%s]", this.foundBy);
    }
}

