/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os.win32;

import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.win32.Kernel32;

@Beta
public class WindowsProcessGroup {
    private Kernel32 Kernel32 = org.openqa.selenium.os.win32.Kernel32.INSTANCE;
    private String cmd;
    private WinNT.HANDLE hJob;

    public WindowsProcessGroup(String ... executableAndArgs) {
        StringBuilder toExecute = new StringBuilder();
        for (String arg : executableAndArgs) {
            toExecute.append(" ").append(this.quote(arg));
        }
        this.cmd = toExecute.toString();
    }

    private String quote(String toQuote) {
        if (toQuote.indexOf(32) != -1) {
            return '\"' + toQuote + '\"';
        }
        return toQuote;
    }

    public void executeAsync() {
        WinBase.STARTUPINFO si = new WinBase.STARTUPINFO();
        si.clear();
        WinBase.PROCESS_INFORMATION.ByReference pi = new WinBase.PROCESS_INFORMATION.ByReference();
        pi.clear();
        Kernel32.JOBJECT_EXTENDED_LIMIT_INFORMATION.ByReference jeli = new Kernel32.JOBJECT_EXTENDED_LIMIT_INFORMATION.ByReference();
        jeli.clear();
        this.hJob = this.Kernel32.CreateJobObject(null, null);
        if (this.hJob.getPointer() == null) {
            throw new WebDriverException("Cannot create job object");
        }
        jeli.BasicLimitInformation.LimitFlags = 0x800 | 0x2000;
        if (!this.Kernel32.SetInformationJobObject(this.hJob, 9, jeli.getPointer(), jeli.size())) {
            throw new WebDriverException("Unable to set information on the job object");
        }
        boolean result = this.Kernel32.CreateProcess(null, this.cmd, null, null, false, new WinDef.DWORD(0x1000004L), null, null, si, pi);
        if (!result) {
            throw new WebDriverException("Failed to create the process");
        }
        if (!this.Kernel32.AssignProcessToJobObject(this.hJob, pi.hProcess)) {
            throw new WebDriverException("Cannot assign process to job: " + this.Kernel32.GetLastError());
        }
        if (this.Kernel32.ResumeThread(pi.hThread) == 0) {
            throw new WebDriverException("Cannot resume thread");
        }
        this.Kernel32.CloseHandle(pi.hThread);
        this.Kernel32.CloseHandle(pi.hProcess);
    }

    public void destroy() {
        if (this.hJob == null) {
            return;
        }
        this.Kernel32.TerminateJobObject(this.hJob, 666L);
        this.hJob = null;
    }
}

