/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven;

import com.thoughtworks.selenium.webdriven.FunctionDeclaration;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.ScriptMutator;
import com.thoughtworks.selenium.webdriven.SeleniumMutator;
import com.thoughtworks.selenium.webdriven.VariableDeclaration;
import java.util.ArrayList;
import java.util.List;

public class CompoundMutator
implements ScriptMutator {
    private final List<ScriptMutator> mutators = new ArrayList<ScriptMutator>();

    public CompoundMutator(String baseUrl) {
        this.addMutator(new VariableDeclaration("selenium", "var selenium = {};"));
        this.addMutator(new VariableDeclaration("selenium.browserbot", "selenium.browserbot = {};"));
        this.addMutator(new VariableDeclaration("selenium.browserbot.baseUrl", "selenium.browserbot.baseUrl = '" + baseUrl + "';"));
        this.addMutator(new VariableDeclaration("browserVersion", "var browserVersion = {};"));
        this.addMutator(new VariableDeclaration("browserVersion.isFirefox", "browserVersion.isFirefox = navigator.userAgent.indexOf('Firefox') != -1 || navigator.userAgent.indexOf('Namoroka') != -1 || navigator.userAgent.indexOf('Shiretoko') != -1;"));
        this.addMutator(new VariableDeclaration("browserVersion.isGecko", "browserVersion.isGecko = navigator.userAgent.indexOf('Firefox') != -1 || navigator.userAgent.indexOf('Namoroka') != -1 || navigator.userAgent.indexOf('Shiretoko') != -1;"));
        this.addMutator(new VariableDeclaration("browserVersion.firefoxVersion", "var r = /.*[Firefox|Namoroka|Shiretoko]\\/([\\d\\.]+).*/.exec(navigator.userAgent);browserVersion.firefoxVersion = r ? r[1] : '';"));
        this.addMutator(new VariableDeclaration("browserVersion.isIE", "browserVersion.isIE = navigator.appName == 'Microsoft Internet Explorer';"));
        this.addMutator(new FunctionDeclaration("selenium.page", "if (!selenium.browserbot) { selenium.browserbot = {} }; return selenium.browserbot;"));
        this.addMutator(new FunctionDeclaration("selenium.browserbot.getCurrentWindow", "return window;"));
        this.addMutator(new FunctionDeclaration("selenium.browserbot.getUserWindow", "return window;"));
        this.addMutator(new FunctionDeclaration("selenium.page().getCurrentWindow", "return window;"));
        this.addMutator(new FunctionDeclaration("selenium.browserbot.getDocument", "return document;"));
        this.addMutator(new FunctionDeclaration("selenium.page().getDocument", "return document;"));
        JavascriptLibrary library = new JavascriptLibrary();
        this.addMutator(new SeleniumMutator("selenium.getText", library.getSeleniumScript("getText.js")));
        this.addMutator(new SeleniumMutator("selenium.isElementPresent", library.getSeleniumScript("isElementPresent.js")));
        this.addMutator(new SeleniumMutator("selenium.isTextPresent", library.getSeleniumScript("isTextPresent.js")));
        this.addMutator(new SeleniumMutator("selenium.isVisible", library.getSeleniumScript("isVisible.js")));
        this.addMutator(new SeleniumMutator("selenium.browserbot.findElement", library.getSeleniumScript("findElement.js")));
    }

    public void addMutator(ScriptMutator mutator) {
        this.mutators.add(mutator);
    }

    @Override
    public void mutate(String script, StringBuilder outputTo) {
        StringBuilder nested = new StringBuilder();
        for (ScriptMutator mutator : this.mutators) {
            mutator.mutate(script, nested);
        }
        nested.append(script);
        outputTo.append("return eval('");
        outputTo.append(this.escape(nested.toString()));
        outputTo.append("');");
    }

    private String escape(String escapee) {
        return escapee.replace("\\", "\\\\").replace("\n", "\\n").replace("'", "\\'");
    }
}

