/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.log.FlushingHandler;
import org.openqa.selenium.grid.log.JsonFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.empty.NullTracer;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;

public class LoggingOptions {
    private static final Logger LOG = Logger.getLogger(LoggingOptions.class.getName());
    private static final String LOGGING_SECTION = "logging";
    private Level level = Level.INFO;
    private final Config config;

    public LoggingOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public boolean isUsingStructuredLogging() {
        return this.config.getBool(LOGGING_SECTION, "structured-logs").orElse(false);
    }

    public boolean isUsingPlainLogs() {
        return this.config.getBool(LOGGING_SECTION, "plain-logs").orElse(true);
    }

    public String getLogEncoding() {
        return this.config.get(LOGGING_SECTION, "log-encoding").orElse(null);
    }

    public void setLoggingLevel() {
        String configLevel = this.config.get(LOGGING_SECTION, "log-level").orElse(Level.INFO.getName());
        if (Level.ALL.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.ALL;
        } else if (Level.CONFIG.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.CONFIG;
        } else if (Level.FINE.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.FINE;
        } else if (Level.FINER.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.FINER;
        } else if (Level.FINEST.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.FINEST;
        } else if (Level.OFF.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.OFF;
        } else if (Level.SEVERE.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.SEVERE;
        } else if (Level.WARNING.getName().equalsIgnoreCase(configLevel)) {
            this.level = Level.WARNING;
        }
    }

    public Tracer getTracer() {
        boolean tracingEnabled = this.config.getBool(LOGGING_SECTION, "tracing").orElse(true);
        if (!tracingEnabled) {
            LOG.info("Using null tracer");
            return new NullTracer();
        }
        return OpenTelemetryTracer.getInstance();
    }

    public void configureLogging() {
        FlushingHandler handler;
        Logger logger;
        if (!this.config.getBool(LOGGING_SECTION, "enable").orElse(true).booleanValue()) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        while (names.hasMoreElements()) {
            logger = logManager.getLogger(names.nextElement());
            if (logger == null) continue;
            Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler);
        }
        logger = logManager.getLogger("");
        this.setLoggingLevel();
        logger.setLevel(this.level);
        OutputStream out = this.getOutputStream();
        String encoding = this.getLogEncoding();
        if (this.isUsingPlainLogs()) {
            handler = new FlushingHandler(out);
            handler.setFormatter(new TerseFormatter());
            handler.setLevel(this.level);
            this.configureLogEncoding(logger, encoding, handler);
        }
        if (this.isUsingStructuredLogging()) {
            handler = new FlushingHandler(out);
            handler.setFormatter(new JsonFormatter());
            handler.setLevel(this.level);
            this.configureLogEncoding(logger, encoding, handler);
        }
    }

    private void configureLogEncoding(Logger logger, String encoding, Handler handler) {
        String message;
        try {
            if (encoding != null) {
                handler.setEncoding(encoding);
                message = String.format("Using encoding %s", encoding);
            } else {
                message = "Using the system default encoding";
            }
        }
        catch (UnsupportedEncodingException e) {
            message = String.format("Using the system default encoding. Unsupported encoding %s", encoding);
        }
        logger.addHandler(handler);
        logger.log(Level.INFO, message);
    }

    private OutputStream getOutputStream() {
        return this.config.get(LOGGING_SECTION, "log-file").map(fileName -> {
            try {
                return new FileOutputStream((String)fileName);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
        }).orElse(System.out);
    }
}

